/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.transfer.RectifiedLinear;
import org.neuroph.nnet.comp.Kernel;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;
import org.neuroph.nnet.comp.layer.Layer2D;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.NeuronProperties;

public class ConvolutionalLayer
extends FeatureMapsLayer {
    private static final long serialVersionUID = -4619196904153707871L;
    public static final NeuronProperties DEFAULT_NEURON_PROP = new NeuronProperties();

    public ConvolutionalLayer(FeatureMapsLayer fromLayer, Kernel kernel) {
        super(kernel);
        Layer2D.Dimensions fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() - (kernel.getWidth() - 1);
        int mapHeight = fromDimension.getHeight() - (kernel.getHeight() - 1);
        this.mapDimensions = new Layer2D.Dimensions(mapWidth, mapHeight);
        this.createFeatureMaps(1, this.mapDimensions, DEFAULT_NEURON_PROP);
    }

    public ConvolutionalLayer(FeatureMapsLayer fromLayer, Kernel kernel, int numberOfMaps) {
        super(kernel);
        Layer2D.Dimensions fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() - (kernel.getWidth() - 1);
        int mapHeight = fromDimension.getHeight() - (kernel.getHeight() - 1);
        this.mapDimensions = new Layer2D.Dimensions(mapWidth, mapHeight);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, DEFAULT_NEURON_PROP);
    }

    public ConvolutionalLayer(FeatureMapsLayer fromLayer, Kernel kernel, int numberOfMaps, NeuronProperties neuronProp) {
        super(kernel);
        Layer2D.Dimensions fromDimension = fromLayer.getMapDimensions();
        int mapWidth = fromDimension.getWidth() - (kernel.getWidth() - 1);
        int mapHeight = fromDimension.getHeight() - (kernel.getHeight() - 1);
        this.mapDimensions = new Layer2D.Dimensions(mapWidth, mapHeight);
        this.createFeatureMaps(numberOfMaps, this.mapDimensions, neuronProp);
    }

    @Override
    public void connectMaps(Layer2D fromMap, Layer2D toMap) {
        Weight[][] weights = new Weight[this.kernel.getHeight()][this.kernel.getWidth()];
        for (int i = 0; i < this.kernel.getHeight(); ++i) {
            for (int j = 0; j < this.kernel.getWidth(); ++j) {
                Weight weight = new Weight();
                weight.randomize(-0.15, 0.15);
                weights[i][j] = weight;
            }
        }
        this.kernel.setWeights(weights);
        for (int x = 0; x < toMap.getWidth(); ++x) {
            for (int y = 0; y < toMap.getHeight(); ++y) {
                Neuron toNeuron = toMap.getNeuronAt(x, y);
                for (int ky = 0; ky < this.kernel.getHeight(); ++ky) {
                    for (int kx = 0; kx < this.kernel.getWidth(); ++kx) {
                        int fromX = x + kx;
                        int fromY = y + ky;
                        Weight[][] concreteKernel = this.kernel.getWeights();
                        Neuron fromNeuron = fromMap.getNeuronAt(fromX, fromY);
                        ConnectionFactory.createConnection(fromNeuron, toNeuron, concreteKernel[kx][ky]);
                    }
                }
            }
        }
    }

    private double getWeightCoeficient(Layer2D toMap) {
        int numberOfInputConnections = toMap.getNeuronAt(0, 0).getInputConnections().length;
        double coefficient = 1.0 / Math.sqrt(numberOfInputConnections);
        coefficient = !Double.isInfinite(coefficient) || !Double.isNaN(coefficient) || coefficient == 0.0 ? 1.0 : coefficient;
        return coefficient;
    }

    static {
        DEFAULT_NEURON_PROP.setProperty("useBias", true);
        DEFAULT_NEURON_PROP.setProperty("transferFunction", RectifiedLinear.class);
        DEFAULT_NEURON_PROP.setProperty("inputFunction", WeightedSum.class);
    }
}

