/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.comp.neuron.ThresholdNeuron;
import org.neuroph.nnet.learning.BinaryDeltaRule;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class Perceptron
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public Perceptron(int inputNeuronsCount, int outputNeuronsCount) {
        this.createNetwork(inputNeuronsCount, outputNeuronsCount, TransferFunctionType.STEP);
    }

    public Perceptron(int inputNeuronsCount, int outputNeuronsCount, TransferFunctionType transferFunctionType) {
        this.createNetwork(inputNeuronsCount, outputNeuronsCount, transferFunctionType);
    }

    private void createNetwork(int inputNeuronsCount, int outputNeuronsCount, TransferFunctionType transferFunctionType) {
        this.setNetworkType(NeuralNetworkType.PERCEPTRON);
        NeuronProperties inputNeuronProperties = new NeuronProperties();
        inputNeuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.LINEAR);
        Layer inputLayer = LayerFactory.createLayer(inputNeuronsCount, inputNeuronProperties);
        this.addLayer(inputLayer);
        NeuronProperties outputNeuronProperties = new NeuronProperties();
        outputNeuronProperties.setProperty("neuronType", ThresholdNeuron.class);
        outputNeuronProperties.setProperty("thresh", new Double(Math.abs(Math.random())));
        outputNeuronProperties.setProperty("transferFunction", (Object)transferFunctionType);
        outputNeuronProperties.setProperty("transferFunction.slope", new Double(1.0));
        Layer outputLayer = LayerFactory.createLayer(outputNeuronsCount, outputNeuronProperties);
        this.addLayer(outputLayer);
        ConnectionFactory.fullConnect(inputLayer, outputLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new BinaryDeltaRule());
    }
}

