/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.input.Min;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.transfer.Linear;
import org.neuroph.core.transfer.Trapezoid;
import org.neuroph.nnet.learning.LMS;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class NeuroFuzzyPerceptron
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public NeuroFuzzyPerceptron(double[][] pointsSets, double[][] timeSets) {
        ArrayList<Integer> inputSets = new ArrayList<Integer>();
        inputSets.add(4);
        inputSets.add(3);
        this.createStudentNFR(2, inputSets, 4, pointsSets, timeSets);
    }

    public NeuroFuzzyPerceptron(int inputNum, Vector<Integer> inputSets, int outNum) {
        this.createNetwork(inputNum, inputSets, outNum);
    }

    private void createStudentNFR(int inputNum, List<Integer> inputSets, int outNum, double[][] pointsSets, double[][] timeSets) {
        this.setNetworkType(NeuralNetworkType.NEURO_FUZZY_REASONER);
        NeuronProperties neuronProperties = new NeuronProperties();
        Layer inLayer = LayerFactory.createLayer(inputNum, neuronProperties);
        this.addLayer(inLayer);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.TRAPEZOID);
        Iterator<Integer> e = inputSets.iterator();
        int fuzzySetsNum = 0;
        while (e.hasNext()) {
            Integer i = e.next();
            fuzzySetsNum += i.intValue();
        }
        Layer setLayer = LayerFactory.createLayer(fuzzySetsNum, neuronProperties);
        this.addLayer(setLayer);
        int c = 0;
        for (Neuron cell : setLayer.getNeurons()) {
            Trapezoid tf = (Trapezoid)cell.getTransferFunction();
            if (c <= 3) {
                tf.setLeftLow(pointsSets[c][0]);
                tf.setLeftHigh(pointsSets[c][1]);
                tf.setRightLow(pointsSets[c][3]);
                tf.setRightHigh(pointsSets[c][2]);
            } else {
                tf.setLeftLow(timeSets[c - 4][0]);
                tf.setLeftHigh(timeSets[c - 4][1]);
                tf.setRightLow(timeSets[c - 4][3]);
                tf.setRightHigh(timeSets[c - 4][2]);
            }
            ++c;
        }
        int s = 0;
        for (int i = 0; i < inputNum; ++i) {
            Neuron from = inLayer.getNeuronAt(i);
            int jmax = inputSets.get(i);
            for (int j = 0; j < jmax; ++j) {
                Neuron to = setLayer.getNeuronAt(s);
                ConnectionFactory.createConnection(from, to, 1.0);
                ++s;
            }
        }
        NeuronProperties ruleNeuronProperties = new NeuronProperties(Neuron.class, WeightedSum.class, Linear.class);
        Iterator<Integer> en = inputSets.iterator();
        int fuzzyAntNum = 1;
        while (en.hasNext()) {
            Integer i = en.next();
            fuzzyAntNum *= i.intValue();
        }
        Layer ruleLayer = LayerFactory.createLayer(fuzzyAntNum, ruleNeuronProperties);
        this.addLayer(ruleLayer);
        int scIdx = 0;
        for (int i = 0; i < inputNum; ++i) {
            int setsNum = inputSets.get(i);
            for (int si = 0; si < setsNum; ++si) {
                int k;
                int connPerCell;
                Neuron from;
                if (i == 0) {
                    from = setLayer.getNeuronAt(si);
                    connPerCell = fuzzyAntNum / setsNum;
                    scIdx = si;
                    for (k = 0; k < connPerCell; ++k) {
                        Neuron to = ruleLayer.getNeuronAt(si * connPerCell + k);
                        ConnectionFactory.createConnection(from, to, 1.0);
                    }
                    continue;
                }
                from = setLayer.getNeuronAt(++scIdx);
                connPerCell = fuzzyAntNum / setsNum;
                for (k = 0; k < connPerCell; ++k) {
                    int toIdx = si + k * setsNum;
                    Neuron to = ruleLayer.getNeuronAt(toIdx);
                    ConnectionFactory.createConnection(from, to, 1.0);
                }
            }
        }
        neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.STEP);
        Layer outLayer = LayerFactory.createLayer(outNum, neuronProperties);
        this.addLayer(outLayer);
        ConnectionFactory.fullConnect(ruleLayer, outLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new LMS());
    }

    private void createNetwork(int inputNum, Vector<Integer> inputSets, int outNum) {
        this.setNetworkType(NeuralNetworkType.NEURO_FUZZY_REASONER);
        NeuronProperties neuronProperties = new NeuronProperties();
        Layer inLayer = LayerFactory.createLayer(inputNum, neuronProperties);
        this.addLayer(inLayer);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.TRAPEZOID);
        Enumeration<Integer> e = inputSets.elements();
        int fuzzySetsNum = 0;
        while (e.hasMoreElements()) {
            Integer i = e.nextElement();
            fuzzySetsNum += i.intValue();
        }
        Layer setLayer = LayerFactory.createLayer(fuzzySetsNum, neuronProperties);
        this.addLayer(setLayer);
        boolean c = false;
        for (Neuron cell : setLayer.getNeurons()) {
            Trapezoid trapezoid = (Trapezoid)cell.getTransferFunction();
        }
        int s = 0;
        for (int i = 0; i < inputNum; ++i) {
            Neuron from = inLayer.getNeuronAt(i);
            int jmax = inputSets.elementAt(i);
            for (int j = 0; j < jmax; ++j) {
                Neuron to = setLayer.getNeuronAt(s);
                ConnectionFactory.createConnection(from, to, 1.0);
                ++s;
            }
        }
        neuronProperties.setProperty("inputFunction", Min.class);
        neuronProperties.setProperty("transferFunction", Linear.class);
        Enumeration<Integer> en = inputSets.elements();
        int fuzzyAntNum = 1;
        while (en.hasMoreElements()) {
            Integer i = en.nextElement();
            fuzzyAntNum *= i.intValue();
        }
        Layer ruleLayer = LayerFactory.createLayer(fuzzyAntNum, neuronProperties);
        this.addLayer(ruleLayer);
        int scIdx = 0;
        for (int i = 0; i < inputNum; ++i) {
            int setsNum = inputSets.elementAt(i);
            for (int si = 0; si < setsNum; ++si) {
                int k;
                int connPerCell;
                Neuron from;
                if (i == 0) {
                    from = setLayer.getNeuronAt(si);
                    connPerCell = fuzzyAntNum / setsNum;
                    scIdx = si;
                    for (k = 0; k < connPerCell; ++k) {
                        Neuron to = ruleLayer.getNeuronAt(si * connPerCell + k);
                        ConnectionFactory.createConnection(from, to, 1.0);
                    }
                    continue;
                }
                from = setLayer.getNeuronAt(++scIdx);
                connPerCell = fuzzyAntNum / setsNum;
                for (k = 0; k < connPerCell; ++k) {
                    int toIdx = si + k * setsNum;
                    Neuron to = ruleLayer.getNeuronAt(toIdx);
                    ConnectionFactory.createConnection(from, to, 1.0);
                }
            }
        }
        neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.STEP);
        Layer outLayer = LayerFactory.createLayer(outNum, neuronProperties);
        this.addLayer(outLayer);
        ConnectionFactory.fullConnect(ruleLayer, outLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new LMS());
    }
}

