/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.learning.InstarLearning;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class Instar
extends NeuralNetwork {
    private static final long serialVersionUID = 1L;

    public Instar(int inputNeuronsCount) {
        this.createNetwork(inputNeuronsCount);
    }

    private void createNetwork(int inputNeuronsCount) {
        this.setNetworkType(NeuralNetworkType.INSTAR);
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.STEP);
        Layer inputLayer = LayerFactory.createLayer(inputNeuronsCount, neuronProperties);
        this.addLayer(inputLayer);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.STEP);
        Layer outputLayer = LayerFactory.createLayer(1, neuronProperties);
        this.addLayer(outputLayer);
        ConnectionFactory.fullConnect(inputLayer, outputLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new InstarLearning());
    }
}

