/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.comp.layer.InputLayer;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class ElmanNetwork
extends NeuralNetwork {
    public ElmanNetwork(int inputNeuronsCount, int hiddenNeuronsCount, int contextNeuronsCount, int outputNeuronsCount) {
        this.createNetwork(inputNeuronsCount, hiddenNeuronsCount, contextNeuronsCount, outputNeuronsCount);
    }

    private void createNetwork(int inputNeuronsCount, int hiddenNeuronsCount, int contextNeuronsCount, int outputNeuronsCount) {
        InputLayer inputLayer = new InputLayer(inputNeuronsCount);
        inputLayer.addNeuron(new BiasNeuron());
        this.addLayer(inputLayer);
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.SIGMOID);
        Layer hiddenLayer = new Layer(hiddenNeuronsCount, neuronProperties);
        hiddenLayer.addNeuron(new BiasNeuron());
        this.addLayer(hiddenLayer);
        ConnectionFactory.fullConnect((Layer)inputLayer, hiddenLayer);
        Layer contextLayer = new Layer(contextNeuronsCount, neuronProperties);
        this.addLayer(contextLayer);
        Layer outputLayer = new Layer(outputNeuronsCount, neuronProperties);
        this.addLayer(outputLayer);
        ConnectionFactory.fullConnect(hiddenLayer, outputLayer);
        ConnectionFactory.forwardConnect(hiddenLayer, contextLayer);
        ConnectionFactory.fullConnect(contextLayer, hiddenLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new BackPropagation());
    }
}

