/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.exceptions.VectorSizeMismatchException;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.nnet.comp.ConvolutionalUtils;
import org.neuroph.nnet.comp.Kernel;
import org.neuroph.nnet.comp.layer.ConvolutionalLayer;
import org.neuroph.nnet.comp.layer.FeatureMapsLayer;
import org.neuroph.nnet.comp.layer.InputMapsLayer;
import org.neuroph.nnet.comp.layer.Layer2D;
import org.neuroph.nnet.comp.layer.PoolingLayer;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.nnet.learning.MomentumBackpropagation;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class ConvolutionalNetwork
extends NeuralNetwork<BackPropagation> {
    private static final long serialVersionUID = -1393907449047650509L;

    @Override
    public void setInput(double ... inputVector) throws VectorSizeMismatchException {
        FeatureMapsLayer inputLayer = (FeatureMapsLayer)this.getLayerAt(0);
        int currentNeuron = 0;
        for (int i = 0; i < inputLayer.getNumberOfMaps(); ++i) {
            Layer2D map = inputLayer.getFeatureMap(i);
            for (Neuron neuron : map.getNeurons()) {
                if (neuron instanceof BiasNeuron) continue;
                neuron.setInput(inputVector[currentNeuron++]);
            }
        }
    }

    public static class Builder {
        public static final NeuronProperties DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES = new NeuronProperties();
        private ConvolutionalNetwork network = new ConvolutionalNetwork();

        public Builder(Layer2D.Dimensions mapSize, int numberOfMaps) {
            InputMapsLayer inputLayer = new InputMapsLayer(mapSize, numberOfMaps);
            inputLayer.setLabel("Input Layer");
            this.network.addLayer(inputLayer);
        }

        public Builder withConvolutionLayer(Kernel convolutionKernel, int numberOfMaps) {
            FeatureMapsLayer lastLayer = this.getLastFeatureMapLayer();
            ConvolutionalLayer convolutionLayer = new ConvolutionalLayer(lastLayer, convolutionKernel, numberOfMaps);
            this.network.addLayer(convolutionLayer);
            ConvolutionalUtils.fullConnectMapLayers(lastLayer, convolutionLayer);
            return this;
        }

        public Builder withPoolingLayer(Kernel poolingKernel) {
            FeatureMapsLayer lastLayer = this.getLastFeatureMapLayer();
            PoolingLayer poolingLayer = new PoolingLayer(lastLayer, poolingKernel);
            this.network.addLayer(poolingLayer);
            ConvolutionalUtils.fullConnectMapLayers(lastLayer, poolingLayer);
            return this;
        }

        public Builder withFullConnectedLayer(int numberOfNeurons) {
            Layer lastLayer = this.getLastLayer();
            Layer fullConnectedLayer = new Layer(numberOfNeurons, DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES);
            this.network.addLayer(fullConnectedLayer);
            ConnectionFactory.fullConnect(lastLayer, fullConnectedLayer);
            return this;
        }

        public ConvolutionalNetwork createNetwork() {
            this.network.setInputNeurons(this.network.getLayerAt(0).getNeurons());
            this.network.setOutputNeurons(this.getLastLayer().getNeurons());
            this.network.setLearningRule(new MomentumBackpropagation());
            return this.network;
        }

        private FeatureMapsLayer getLastFeatureMapLayer() {
            Layer layer = this.getLastLayer();
            if (layer instanceof FeatureMapsLayer) {
                return (FeatureMapsLayer)layer;
            }
            throw new RuntimeException("Unable to add next layer because previous layer is not FeatureMapLayer");
        }

        private Layer getLastLayer() {
            return this.network.getLayerAt(this.network.getLayersCount() - 1);
        }

        static {
            DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES.setProperty("useBias", true);
            DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES.setProperty("transferFunction", (Object)TransferFunctionType.SIGMOID);
            DEFAULT_FULL_CONNECTED_NEURON_PROPERTIES.setProperty("inputFunction", WeightedSum.class);
        }
    }
}

