/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.input;

import java.io.Serializable;
import org.neuroph.core.Connection;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.input.InputFunction;

public class Difference
extends InputFunction
implements Serializable {
    private static final long serialVersionUID = 21L;

    @Override
    public double getOutput(Connection[] inputConnections) {
        double output = 0.0;
        double sum = 0.0;
        for (Connection connection : inputConnections) {
            Neuron neuron = connection.getFromNeuron();
            Weight weight = connection.getWeight();
            double diff = neuron.getOutput() - weight.getValue();
            sum += diff * diff;
        }
        output = Math.sqrt(sum);
        return output;
    }

    public double[] getOutput(double[] inputs, double[] weights) {
        double[] output = new double[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            output[i] = inputs[i] - weights[i];
        }
        return output;
    }
}

