/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.exceptions.NeurophException;
import org.neuroph.core.exceptions.VectorSizeMismatchException;
import org.neuroph.util.data.sample.Sampling;
import org.neuroph.util.data.sample.SubSampling;

public class DataSet
implements Serializable {
    private static final long serialVersionUID = 2L;
    private List<DataSetRow> rows = new ArrayList<DataSetRow>();
    private int inputSize = 0;
    private int outputSize = 0;
    private String[] columnNames;
    private boolean isSupervised = false;
    private String label;
    private transient String filePath;

    public DataSet(int inputSize) {
        this.inputSize = inputSize;
        this.isSupervised = false;
        this.columnNames = new String[inputSize];
    }

    public DataSet(int inputSize, int outputSize) {
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.isSupervised = true;
        this.columnNames = new String[inputSize + outputSize];
    }

    public void addRow(DataSetRow row) throws VectorSizeMismatchException {
        if (row == null) {
            throw new IllegalArgumentException("Data set row cannot be null!");
        }
        if (this.inputSize != 0 && row.getInput().length != this.inputSize) {
            throw new VectorSizeMismatchException("Input vector size does not match data set input size!");
        }
        if (this.outputSize != 0 && row.getDesiredOutput().length != this.outputSize) {
            throw new VectorSizeMismatchException("Output vector size does not match data set output size!");
        }
        this.rows.add(row);
    }

    public void addRow(double[] input) {
        if (input == null) {
            throw new IllegalArgumentException("Input for dataset row cannot be null!");
        }
        if (input.length != this.inputSize) {
            throw new NeurophException("Input size for given row is different from the data set size!");
        }
        if (this.isSupervised) {
            throw new NeurophException("Cannot add unsupervised row to supervised data set!");
        }
        this.addRow(new DataSetRow(input));
    }

    public void addRow(double[] input, double[] output) {
        this.addRow(new DataSetRow(input, output));
    }

    public void removeRowAt(int idx) {
        this.rows.remove(idx);
    }

    public Iterator<DataSetRow> iterator() {
        return this.rows.iterator();
    }

    public List<DataSetRow> getRows() {
        return this.rows;
    }

    public DataSetRow getRowAt(int idx) {
        return this.rows.get(idx);
    }

    public void clear() {
        this.rows.clear();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public boolean isSupervised() {
        return this.isSupervised;
    }

    public int size() {
        return this.rows.size();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String getColumnName(int idx) {
        return this.columnNames[idx];
    }

    public void setColumnName(int idx, String columnName) {
        this.columnNames[idx] = columnName;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dataset Label: ").append(this.label).append(System.lineSeparator());
        if (this.columnNames != null) {
            sb.append("Columns: ");
            for (String columnName : this.columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length() - 1);
            sb.append(System.lineSeparator());
        }
        for (DataSetRow row : this.rows) {
            sb.append(row).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String toCSV() {
        StringBuilder sb = new StringBuilder();
        if (this.columnNames != null && this.columnNames.length > 0) {
            for (String columnName : this.columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length() - 1);
            sb.append(System.lineSeparator());
        }
        for (DataSetRow row : this.rows) {
            sb.append(row.toCSV());
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public void save(String filePath) {
        this.filePath = filePath;
        this.save();
    }

    public void save() {
        ObjectOutputStream out = null;
        try {
            File file = new File(this.filePath);
            out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(this);
            out.flush();
        }
        catch (IOException ioe) {
            throw new NeurophException(ioe);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveAsTxt(String filePath, String delimiter) {
        if (filePath == null) {
            throw new IllegalArgumentException("File path is null!");
        }
        if (delimiter == null || delimiter.equals("")) {
            delimiter = " ";
        }
        try (PrintWriter out = new PrintWriter(new FileWriter(new File(filePath)));){
            int columnCount = this.inputSize + this.outputSize;
            if (this.columnNames != null && this.columnNames.length > 0) {
                for (int i = 0; i < this.columnNames.length; ++i) {
                    out.print(this.columnNames[i]);
                    if (i >= columnCount - 1) continue;
                    out.print(delimiter);
                }
                out.println();
            }
            for (DataSetRow row : this.rows) {
                double[] input = row.getInput();
                for (int i = 0; i < input.length; ++i) {
                    out.print(input[i]);
                    if (i >= columnCount - 1) continue;
                    out.print(delimiter);
                }
                if (row.isSupervised()) {
                    double[] output = row.getDesiredOutput();
                    for (int j = 0; j < output.length; ++j) {
                        out.print(output[j]);
                        if (this.inputSize + j >= columnCount - 1) continue;
                        out.print(delimiter);
                    }
                }
                out.println();
            }
            out.flush();
        }
        catch (IOException ex) {
            throw new NeurophException("Error saving data set file!", ex);
        }
    }

    public static DataSet load(String filePath) {
        ObjectInputStream oistream = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                throw new FileNotFoundException("Cannot find file: " + filePath);
            }
            oistream = new ObjectInputStream(new FileInputStream(filePath));
            DataSet dataSet = (DataSet)oistream.readObject();
            dataSet.setFilePath(filePath);
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
        catch (IOException ioe) {
            throw new NeurophException("Error reading file!", ioe);
        }
        catch (ClassNotFoundException ex) {
            throw new NeurophException("Class not found while trying to read DataSet object from the stream!", ex);
        }
        finally {
            if (oistream != null) {
                try {
                    oistream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static DataSet createFromFile(String filePath, int inputsCount, int outputsCount, String delimiter, boolean loadColumnNames) {
        BufferedReader reader = null;
        if (filePath == null) {
            throw new IllegalArgumentException("File name cannot be null!");
        }
        if (inputsCount <= 0) {
            throw new IllegalArgumentException("Number of inputs cannot be <= 0");
        }
        if (outputsCount < 0) {
            throw new IllegalArgumentException("Number of outputs cannot be < 0");
        }
        if (delimiter == null || delimiter.isEmpty()) {
            throw new IllegalArgumentException("Delimiter cannot be null or empty!");
        }
        try {
            DataSet dataSet = new DataSet(inputsCount, outputsCount);
            dataSet.setFilePath(filePath);
            reader = new BufferedReader(new FileReader(new File(filePath)));
            String line = null;
            if (loadColumnNames) {
                line = reader.readLine();
                String[] colNames = line.split(delimiter);
                dataSet.setColumnNames(colNames);
            }
            while ((line = reader.readLine()) != null) {
                int i;
                String[] values = line.split(delimiter);
                double[] inputs = new double[inputsCount];
                double[] outputs = new double[outputsCount];
                if (values[0].equals("")) continue;
                for (i = 0; i < inputsCount; ++i) {
                    inputs[i] = Double.parseDouble(values[i]);
                }
                for (i = 0; i < outputsCount; ++i) {
                    outputs[i] = Double.parseDouble(values[inputsCount + i]);
                }
                if (outputsCount > 0) {
                    dataSet.addRow(new DataSetRow(inputs, outputs));
                    continue;
                }
                dataSet.addRow(new DataSetRow(inputs));
            }
            reader.close();
            return dataSet;
        }
        catch (FileNotFoundException ex) {
            throw new NeurophException("Could not find data set file!", ex);
        }
        catch (IOException ex) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new NeurophException("Error reading data set file!", ex);
        }
        catch (NumberFormatException ex) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ex.printStackTrace();
            throw new NeurophException("Bad number format in data set file!", ex);
        }
    }

    public static DataSet createFromFile(String filePath, int inputsCount, int outputsCount, String delimiter) {
        return DataSet.createFromFile(filePath, inputsCount, outputsCount, delimiter, false);
    }

    public DataSet[] createTrainingAndTestSubsets(int trainSetPercent, int testSetPercent) {
        SubSampling sampling = new SubSampling(trainSetPercent, testSetPercent);
        DataSet[] trainAndTestSet = new DataSet[2];
        sampling.sample(this).toArray(trainAndTestSet);
        return trainAndTestSet;
    }

    public List<DataSet> sample(Sampling sampling) {
        return sampling.sample(this);
    }

    public int getOutputSize() {
        return this.outputSize;
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public void shuffle() {
        Collections.shuffle(this.rows);
    }
}

