/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core;

import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.events.NeuralNetworkEvent;
import org.neuroph.util.NeuronFactory;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.NeurophArrayList;

public class Layer
implements Serializable {
    private static final long serialVersionUID = 4L;
    private NeuralNetwork parentNetwork;
    protected NeurophArrayList<Neuron> neurons;
    private String label;
    static final ForkJoinPool mainPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());

    public Layer() {
        this.neurons = new NeurophArrayList<Neuron>(Neuron.class);
    }

    public Layer(int neuronsCount) {
        this.neurons = new NeurophArrayList<Neuron>(Neuron.class, neuronsCount);
    }

    public Layer(int neuronsCount, NeuronProperties neuronProperties) {
        this.neurons = new NeurophArrayList<Neuron>(Neuron.class, neuronsCount);
        for (int i = 0; i < neuronsCount; ++i) {
            Neuron neuron = NeuronFactory.createNeuron(neuronProperties);
            this.addNeuron(neuron);
        }
    }

    public final void setParentNetwork(NeuralNetwork parent) {
        this.parentNetwork = parent;
    }

    public final NeuralNetwork getParentNetwork() {
        return this.parentNetwork;
    }

    public final Neuron[] getNeurons() {
        return this.neurons.asArray();
    }

    public final void addNeuron(Neuron neuron) {
        if (neuron == null) {
            throw new IllegalArgumentException("Neuron cant be null!");
        }
        neuron.setParentLayer(this);
        this.neurons.add(neuron);
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(this, NeuralNetworkEvent.Type.NEURON_ADDED));
        }
    }

    public final void addNeuron(int index, Neuron neuron) {
        if (neuron == null) {
            throw new IllegalArgumentException("Neuron cant be null!");
        }
        this.neurons.add(index, neuron);
        neuron.setParentLayer(this);
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(this, NeuralNetworkEvent.Type.NEURON_ADDED));
        }
    }

    public final void setNeuron(int index, Neuron neuron) {
        if (neuron == null) {
            throw new IllegalArgumentException("Neuron cant be null!");
        }
        this.neurons.set(index, neuron);
        neuron.setParentLayer(this);
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(this, NeuralNetworkEvent.Type.NEURON_ADDED));
        }
    }

    public final void removeNeuron(Neuron neuron) {
        int index = this.indexOf(neuron);
        this.removeNeuronAt(index);
    }

    public final void removeNeuronAt(int index) {
        Neuron neuron = this.neurons.get(index);
        neuron.setParentLayer(null);
        neuron.removeAllConnections();
        this.neurons.remove(index);
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(this, NeuralNetworkEvent.Type.NEURON_REMOVED));
        }
    }

    public final void removeAllNeurons() {
        this.neurons.clear();
        if (this.parentNetwork != null) {
            this.parentNetwork.fireNetworkEvent(new NeuralNetworkEvent(this, NeuralNetworkEvent.Type.NEURON_REMOVED));
        }
    }

    public Neuron getNeuronAt(int index) {
        return this.neurons.get(index);
    }

    public int indexOf(Neuron neuron) {
        return this.neurons.indexOf(neuron);
    }

    public int getNeuronsCount() {
        return this.neurons.size();
    }

    public void calculate() {
        for (Neuron neuron : this.neurons.asArray()) {
            neuron.calculate();
        }
    }

    public void reset() {
        for (Neuron neuron : this.neurons) {
            neuron.reset();
        }
    }

    public void initializeWeights(double value) {
        for (Neuron neuron : this.neurons) {
            neuron.initializeWeights(value);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isEmpty() {
        return this.neurons.isEmpty();
    }
}

