/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventhandling.deadletter;

import com.mongodb.client.MongoCursor;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.extensions.mongo.MongoTemplate;
import org.axonframework.extensions.mongo.eventhandling.deadletter.DeadLetterEntry;
import org.axonframework.extensions.mongo.eventhandling.deadletter.DeadLetterEventEntry;
import org.axonframework.extensions.mongo.eventhandling.deadletter.DeadLetterMongoConverter;
import org.axonframework.extensions.mongo.eventhandling.deadletter.EventMessageDeadLetterMongoConverter;
import org.axonframework.extensions.mongo.eventhandling.deadletter.MongoDeadLetter;
import org.axonframework.extensions.mongo.eventhandling.deadletter.NoMongoConverterFoundException;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.documentperevent.EventEntryConfiguration;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.DeadLetterQueueOverflowException;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.NoSuchDeadLetterException;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.WrongDeadLetterTypeException;
import org.axonframework.serialization.Serializer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSequencedDeadLetterQueue<M extends EventMessage<?>>
implements SequencedDeadLetterQueue<M> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String processingGroup;
    private final List<DeadLetterMongoConverter<EventMessage<?>>> converters;
    private final EventEntryConfiguration eventConfiguration;
    private final int maxSequences;
    private final int maxSequenceSize;
    private final MongoTemplate mongoTemplate;
    private final Serializer serializer;
    private final Duration claimDuration;
    private final TransactionManager transactionManager;

    protected <T extends EventMessage<?>> MongoSequencedDeadLetterQueue(Builder<T> builder) {
        builder.validate();
        this.processingGroup = ((Builder)builder).processingGroup;
        this.converters = ((Builder)builder).converters;
        this.eventConfiguration = ((Builder)builder).eventConfiguration;
        this.maxSequences = ((Builder)builder).maxSequences;
        this.maxSequenceSize = ((Builder)builder).maxSequenceSize;
        this.mongoTemplate = ((Builder)builder).mongoTemplate;
        this.serializer = ((Builder)builder).serializer;
        this.claimDuration = ((Builder)builder).claimDuration;
        this.transactionManager = ((Builder)builder).transactionManager;
        DeadLetterEntry.ensureDeadLetterIndexes(this.mongoTemplate.deadLetterCollection());
    }

    public static <M extends EventMessage<?>> Builder<M> builder() {
        return new Builder();
    }

    public void enqueue(@Nonnull Object sequenceIdentifier, @Nonnull DeadLetter<? extends M> letter) throws DeadLetterQueueOverflowException {
        String stringSequenceIdentifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        if (this.isFull(stringSequenceIdentifier)) {
            throw new DeadLetterQueueOverflowException("No room left to enqueue [" + letter.message() + "] for identifier [" + stringSequenceIdentifier + "] since the queue is full.");
        }
        Optional optionalCause = letter.cause();
        if (optionalCause.isPresent()) {
            logger.info("Adding dead letter [{}] because [{}].", (Object)letter.message(), optionalCause.get());
        } else {
            logger.info("Adding dead letter [{}] because the sequence identifier [{}] is already present.", (Object)letter.message(), (Object)stringSequenceIdentifier);
        }
        DeadLetterEventEntry entry = this.converters.stream().filter(c -> c.canConvert((EventMessage)letter.message())).findFirst().map(c -> c.convert((EventMessage)letter.message(), this.serializer)).orElseThrow(() -> new NoMongoConverterFoundException(String.format("No converter found for message of type: [%s]", ((EventMessage)letter.message()).getClass().getName())));
        Document message = entry.asDocument(this.eventConfiguration);
        Long sequenceIndex = this.getNextIndexForSequence(stringSequenceIdentifier);
        logger.info("Storing DeadLetter (id: [{}]) for sequence [{}] with index [{}] in processing group [{}].", new Object[]{entry.getEventIdentifier(), stringSequenceIdentifier, sequenceIndex, this.processingGroup});
        DeadLetterEntry deadLetter = new DeadLetterEntry(this.processingGroup, stringSequenceIdentifier, sequenceIndex, message, letter.enqueuedAt(), letter.lastTouched(), letter.cause().orElse(null), letter.diagnostics(), this.serializer);
        Document document = deadLetter.asDocument();
        this.transactionManager.executeInTransaction(() -> this.mongoTemplate.deadLetterCollection().insertOne((Object)document));
    }

    public void evict(DeadLetter<? extends M> letter) {
        if (!(letter instanceof MongoDeadLetter)) {
            throw new WrongDeadLetterTypeException(String.format("Evict should be called with a MongoDeadLetter instance. Instead got: [%s]", letter.getClass().getName()));
        }
        MongoDeadLetter deadLetter = (MongoDeadLetter)letter;
        if (logger.isInfoEnabled()) {
            logger.info("Trying to evict MongoDeadLetter with processing group {} sequence {} and index {}", new Object[]{this.processingGroup, deadLetter.sequenceIdentifier(), deadLetter.index()});
        }
        DeleteResult result = (DeleteResult)this.transactionManager.fetchInTransaction(() -> this.mongoTemplate.deadLetterCollection().deleteOne(DeadLetterEntry.findOneFilter(this.processingGroup, deadLetter.sequenceIdentifier(), deadLetter.index())));
        if (logger.isInfoEnabled()) {
            if (result.getDeletedCount() == 1L) {
                logger.info("Successfully evict MongoDeadLetter with processing group {} sequence {} and index {}", new Object[]{this.processingGroup, deadLetter.sequenceIdentifier(), deadLetter.index()});
            } else {
                logger.info("Failed to evict MongoDeadLetter with processing group {} sequence {} and index {} with result {}", new Object[]{this.processingGroup, deadLetter.sequenceIdentifier(), deadLetter.index(), result});
            }
        }
    }

    public void requeue(@Nonnull DeadLetter<? extends M> letter, @Nonnull UnaryOperator<DeadLetter<? extends M>> letterUpdater) throws NoSuchDeadLetterException {
        if (!(letter instanceof MongoDeadLetter)) {
            throw new WrongDeadLetterTypeException(String.format("Requeue should be called with a MongoDeadLetter instance. Instead got: [%s]", letter.getClass().getName()));
        }
        DeadLetter updatedLetter = ((DeadLetter)letterUpdater.apply(letter)).markTouched();
        MongoDeadLetter mongoDeadLetter = (MongoDeadLetter)letter;
        Document letterEntityDocument = (Document)this.transactionManager.fetchInTransaction(() -> (Document)this.mongoTemplate.deadLetterCollection().find(DeadLetterEntry.findOneFilter(this.processingGroup, mongoDeadLetter.sequenceIdentifier(), mongoDeadLetter.index())).first());
        if (letterEntityDocument == null) {
            throw new NoSuchDeadLetterException(String.format("Can not find dead letter with processing group [%s], sequence identifier [%s] and index [%s] to requeue.", this.processingGroup, mongoDeadLetter.sequenceIdentifier(), mongoDeadLetter.index()));
        }
        DeadLetterEntry letterEntity = new DeadLetterEntry(letterEntityDocument);
        letterEntity.setDiagnostics(updatedLetter.diagnostics(), this.serializer);
        letterEntity.setLastTouched(updatedLetter.lastTouched());
        updatedLetter.cause().ifPresent(letterEntity::setCause);
        letterEntity.clearProcessingStarted();
        if (logger.isInfoEnabled()) {
            logger.info("Requeueing dead letter with processing group [{}], sequence identifier [{}] and index [{}] with cause [{}]", new Object[]{this.processingGroup, mongoDeadLetter.sequenceIdentifier(), mongoDeadLetter.index(), updatedLetter.cause()});
        }
        this.transactionManager.executeInTransaction(() -> {
            Document cfr_ignored_0 = (Document)this.mongoTemplate.deadLetterCollection().findOneAndReplace(DeadLetterEntry.findOneFilter(this.processingGroup, mongoDeadLetter.sequenceIdentifier(), mongoDeadLetter.index()), (Object)letterEntity.asDocument());
        });
    }

    public boolean contains(@Nonnull Object sequenceIdentifier) {
        String stringSequenceIdentifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        return this.sequenceSize(stringSequenceIdentifier) > 0L;
    }

    public Iterable<DeadLetter<? extends M>> deadLetterSequence(@Nonnull Object sequenceIdentifier) {
        String stringSequenceIdentifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        return this.mongoTemplate.deadLetterCollection().find(DeadLetterEntry.processingGroupAndSequenceIdentifierFilter(this.processingGroup, stringSequenceIdentifier)).sort(DeadLetterEntry.indexSortAscending()).map(DeadLetterEntry::new).map(this::toLetter);
    }

    public Iterable<Iterable<DeadLetter<? extends M>>> deadLetters() {
        return DeadLetterEntry.sequenceIdentifierIterator(this.mongoTemplate.deadLetterCollection(), this.processingGroup).map(sequenceIdentifier -> {
            BuilderUtils.assertNonNull((Object)sequenceIdentifier, (String)"SequenceIdentifier can not be null.");
            return this.deadLetterSequence(sequenceIdentifier);
        });
    }

    @Nonnull
    private MongoDeadLetter<M> toLetter(DeadLetterEntry entry) {
        DeadLetterEventEntry deadLetterEventEntry = entry.getMessage(this.eventConfiguration);
        DeadLetterMongoConverter converter = this.converters.stream().filter(c -> c.canConvert(deadLetterEventEntry)).findFirst().orElseThrow(() -> new NoMongoConverterFoundException(String.format("No converter found to convert message of class [%s].", deadLetterEventEntry.getMessageType())));
        return new MongoDeadLetter(entry, (MetaData)this.serializer.deserialize(entry.getDiagnostics()), converter.convert(deadLetterEventEntry, this.serializer));
    }

    public boolean isFull(@Nonnull Object sequenceIdentifier) {
        String stringSequenceIdentifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        long numberInSequence = this.sequenceSize(stringSequenceIdentifier);
        if (numberInSequence > 0L) {
            return numberInSequence >= (long)this.maxSequenceSize;
        }
        return this.amountOfSequences() >= (long)this.maxSequences;
    }

    public long size() {
        return (Long)this.transactionManager.fetchInTransaction(() -> this.mongoTemplate.deadLetterCollection().countDocuments(DeadLetterEntry.processingGroupFilter(this.processingGroup)));
    }

    public long sequenceSize(@Nonnull Object sequenceIdentifier) {
        String identifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        return (Long)this.transactionManager.fetchInTransaction(() -> this.mongoTemplate.deadLetterCollection().countDocuments(DeadLetterEntry.processingGroupAndSequenceIdentifierFilter(this.processingGroup, identifier)));
    }

    public long amountOfSequences() {
        AtomicLong counter = new AtomicLong(0L);
        this.transactionManager.executeInTransaction(() -> DeadLetterEntry.sequenceIdentifierIterator(this.mongoTemplate.deadLetterCollection(), this.processingGroup).forEach(i -> counter.incrementAndGet()));
        return counter.get();
    }

    public boolean process(@Nonnull Predicate<DeadLetter<? extends M>> sequenceFilter, @Nonnull Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        AtomicReference claimedLetter = new AtomicReference();
        this.transactionManager.executeInTransaction(() -> {
            try (MongoCursor iterator = this.mongoTemplate.deadLetterCollection().aggregate(DeadLetterEntry.firstNotLockedFilter(this.processingGroup, this.getProcessingStartedLimit())).iterator();){
                while (iterator.hasNext() && claimedLetter.get() == null) {
                    MongoDeadLetter<M> current;
                    Document id = (Document)iterator.next();
                    Document document = (Document)this.mongoTemplate.deadLetterCollection().find((Bson)id).first();
                    if (Objects.isNull(document) || DeadLetterEntry.isLocked(this.getProcessingStartedLimit(), document) || !sequenceFilter.test(current = this.toLetter(new DeadLetterEntry(document))) || !this.claimDeadLetter(current)) continue;
                    claimedLetter.set(current);
                }
            }
        });
        if (claimedLetter.get() != null) {
            return this.processLetterAndFollowing((MongoDeadLetter)claimedLetter.get(), processingTask);
        }
        logger.info("No claimable and/or matching dead letters found to process.");
        return false;
    }

    private boolean processLetterAndFollowing(MongoDeadLetter<M> firstDeadLetter, Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        MongoDeadLetter<M> deadLetter = firstDeadLetter;
        while (deadLetter != null) {
            EnqueueDecision decision;
            if (logger.isInfoEnabled()) {
                logger.info("Processing dead letter with sequence identifier [{}] and index [{}]", (Object)deadLetter.sequenceIdentifier(), (Object)deadLetter.index());
            }
            if (!(decision = processingTask.apply(deadLetter)).shouldEnqueue()) {
                MongoDeadLetter<M> oldLetter = deadLetter;
                Document deadLetterDocument = this.findNextDeadLetter(oldLetter);
                if (deadLetterDocument != null) {
                    deadLetter = this.toLetter(new DeadLetterEntry(deadLetterDocument));
                    this.claimDeadLetter(deadLetter);
                } else {
                    deadLetter = null;
                }
                this.evict(oldLetter);
                continue;
            }
            this.requeue(deadLetter, l -> decision.withDiagnostics(l).withCause((Throwable)decision.enqueueCause().orElse(null)));
            return false;
        }
        return true;
    }

    private Document findNextDeadLetter(MongoDeadLetter<M> oldLetter) {
        return (Document)this.transactionManager.fetchInTransaction(() -> (Document)this.mongoTemplate.deadLetterCollection().find(DeadLetterEntry.nextItemInSequenceFilter(this.processingGroup, oldLetter.sequenceIdentifier(), oldLetter.index())).sort(DeadLetterEntry.indexSortAscending()).limit(1).first());
    }

    private boolean claimDeadLetter(MongoDeadLetter<M> deadLetter) {
        Instant processingStartedLimit = this.getProcessingStartedLimit();
        UpdateResult result = (UpdateResult)this.transactionManager.fetchInTransaction(() -> this.mongoTemplate.deadLetterCollection().updateOne(DeadLetterEntry.uniqueNotLockedFilter(this.processingGroup, deadLetter.sequenceIdentifier(), deadLetter.index(), processingStartedLimit), DeadLetterEntry.updateProcessingStarted(GenericDeadLetter.clock.instant())));
        if (result.getMatchedCount() > 0L) {
            logger.info("Claimed dead letter with id [{}] to process.", (Object)result.getUpsertedId());
            return true;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Failed to claim dead letter with sequence identifier [{}] and index [{}].", (Object)deadLetter.sequenceIdentifier(), (Object)deadLetter.index());
        }
        return false;
    }

    private Instant getProcessingStartedLimit() {
        return GenericDeadLetter.clock.instant().minus(this.claimDuration);
    }

    public void clear() {
        this.transactionManager.executeInTransaction(() -> this.mongoTemplate.deadLetterCollection().deleteMany(DeadLetterEntry.processingGroupFilter(this.processingGroup)));
    }

    private Long getNextIndexForSequence(String sequenceIdentifier) {
        Long maxIndex = this.getMaxIndexForSequence(sequenceIdentifier);
        if (maxIndex == null) {
            return 0L;
        }
        return maxIndex + 1L;
    }

    private Long getMaxIndexForSequence(String sequenceIdentifier) {
        Document deadLetterEntry = (Document)this.transactionManager.fetchInTransaction(() -> (Document)this.mongoTemplate.deadLetterCollection().find(DeadLetterEntry.processingGroupAndSequenceIdentifierFilter(this.processingGroup, sequenceIdentifier)).sort(DeadLetterEntry.indexSortDescending()).limit(1).first());
        return DeadLetterEntry.index(deadLetterEntry);
    }

    private String toStringSequenceIdentifier(Object sequenceIdentifier) {
        if (sequenceIdentifier instanceof String) {
            return (String)sequenceIdentifier;
        }
        return Integer.toString(sequenceIdentifier.hashCode());
    }

    public static class Builder<T extends EventMessage<?>> {
        private final List<DeadLetterMongoConverter<EventMessage<?>>> converters = new LinkedList();
        private EventEntryConfiguration eventConfiguration = EventEntryConfiguration.getDefault();
        private String processingGroup = null;
        private int maxSequences = 1024;
        private int maxSequenceSize = 1024;
        private MongoTemplate mongoTemplate;
        private Serializer serializer;
        private Duration claimDuration = Duration.ofSeconds(30L);
        private TransactionManager transactionManager = NoTransactionManager.instance();

        public Builder() {
            this.converters.add(new EventMessageDeadLetterMongoConverter());
        }

        public Builder<T> processingGroup(String processingGroup) {
            BuilderUtils.assertNonEmpty((String)processingGroup, (String)"Can not set processingGroup to an empty String.");
            this.processingGroup = processingGroup;
            return this;
        }

        public Builder<T> eventConfiguration(EventEntryConfiguration eventConfiguration) {
            BuilderUtils.assertNonNull((Object)eventConfiguration, (String)"EventEntryConfiguration may not be null");
            this.eventConfiguration = eventConfiguration;
            return this;
        }

        public Builder<T> maxSequences(int maxSequences) {
            BuilderUtils.assertStrictPositive((int)maxSequences, (String)"The maximum number of sequences should be larger or equal to 0");
            this.maxSequences = maxSequences;
            return this;
        }

        public Builder<T> maxSequenceSize(int maxSequenceSize) {
            BuilderUtils.assertStrictPositive((int)maxSequenceSize, (String)"The maximum number of entries in a sequence should be larger or equal to 128");
            this.maxSequenceSize = maxSequenceSize;
            return this;
        }

        public Builder<T> mongoTemplate(MongoTemplate mongoTemplate) {
            BuilderUtils.assertNonNull((Object)mongoTemplate, (String)"MongoTemplate may not be null");
            this.mongoTemplate = mongoTemplate;
            return this;
        }

        public Builder<T> serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"The serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder<T> clearConverters() {
            this.converters.clear();
            return this;
        }

        public Builder<T> addConverter(DeadLetterMongoConverter<EventMessage<?>> converter) {
            BuilderUtils.assertNonNull(converter, (String)"Can not add a null DeadLetterMongoConverter.");
            this.converters.add(converter);
            return this;
        }

        public Builder<T> claimDuration(Duration claimDuration) {
            BuilderUtils.assertNonNull((Object)claimDuration, (String)"Claim duration can not be set to null.");
            this.claimDuration = claimDuration;
            return this;
        }

        public Builder<T> transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull((Object)transactionManager, (String)"TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public MongoSequencedDeadLetterQueue<T> build() {
            return new MongoSequencedDeadLetterQueue(this);
        }

        protected void validate() {
            BuilderUtils.assertNonEmpty((String)this.processingGroup, (String)"Must supply processingGroup when constructing a MongoSequencedDeadLetterQueue");
            BuilderUtils.assertNonNull((Object)this.mongoTemplate, (String)"Must supply a Mongo template when constructing a MongoSequencedDeadLetterQueue");
            BuilderUtils.assertNonNull((Object)this.serializer, (String)"Must supply a Serializer when constructing a MongoSequencedDeadLetterQueue");
        }
    }
}

