/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.test.matchers.EqualsMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MapEntryMatcher
extends TypeSafeMatcher<Map<String, Object>> {
    private final Map<Matcher<String>, Matcher<Object>> matchers = new HashMap<Matcher<String>, Matcher<Object>>();
    private final Map<String, Object> expectedEntries;
    private final Map<String, Object> additionalEntries = new HashMap<String, Object>();
    private final Map<String, Object> missingEntries = new HashMap<String, Object>();

    public MapEntryMatcher(Map<String, Object> expectedMap) {
        this.expectedEntries = new HashMap<String, Object>(expectedMap);
        for (Map.Entry<String, Object> entry : expectedMap.entrySet()) {
            this.matchers.put(EqualsMatcher.equalTo(entry.getKey()), EqualsMatcher.equalTo(entry.getValue()));
        }
    }

    protected boolean matchesSafely(Map<String, Object> actualMap) {
        this.additionalEntries.clear();
        this.missingEntries.clear();
        Matching matching = new Matching(this.matchers);
        for (Map.Entry<String, Object> item : actualMap.entrySet()) {
            if (matching.matches(item)) continue;
            this.additionalEntries.put(item.getKey(), item.getValue());
        }
        if (!matching.isFinished(actualMap)) {
            for (Map.Entry<String, Object> item : this.expectedEntries.entrySet()) {
                if (!matching.matches(item)) continue;
                this.missingEntries.put(item.getKey(), item.getValue());
            }
            return false;
        }
        return this.additionalEntries.isEmpty();
    }

    public Map<String, Object> getAdditionalEntries() {
        return Collections.unmodifiableMap(this.additionalEntries);
    }

    public Map<String, Object> getMissingEntries() {
        return Collections.unmodifiableMap(this.missingEntries);
    }

    public void describeTo(Description description) {
        description.appendText("map containing ").appendValueList("[", ",", "]", this.expectedEntries.entrySet());
    }

    private static class Matching<S> {
        private final Map<Matcher<String>, Matcher<Object>> matchers;

        public Matching(Map<Matcher<String>, Matcher<Object>> matchers) {
            this.matchers = new HashMap<Matcher<String>, Matcher<Object>>(matchers);
        }

        public boolean matches(Map.Entry<String, Object> item) {
            if (this.matchers.isEmpty()) {
                return false;
            }
            for (Map.Entry<Matcher<String>, Matcher<Object>> matcherEntry : this.matchers.entrySet()) {
                if (!matcherEntry.getKey().matches((Object)item.getKey()) || !matcherEntry.getValue().matches(item.getValue())) continue;
                this.matchers.remove(matcherEntry.getKey());
                return true;
            }
            return false;
        }

        public boolean isFinished(Map<String, Object> items) {
            return this.matchers.isEmpty();
        }
    }
}

