/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import org.axonframework.common.BuilderUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ExactClassMatcher<T>
extends TypeSafeMatcher<T> {
    private final Class<T> expectedClass;

    public static <T> Matcher<T> exactClassOf(Class<T> expectedClass) {
        return new ExactClassMatcher<T>(expectedClass);
    }

    public ExactClassMatcher(Class<T> expectedClass) {
        BuilderUtils.assertNonNull(expectedClass, (String)"The expected class should be non-null.");
        this.expectedClass = expectedClass;
    }

    protected boolean matchesSafely(T item) {
        return this.expectedClass.equals(item.getClass());
    }

    public void describeTo(Description description) {
        description.appendText(this.expectedClass.getName());
        description.appendText(" does not match with the actual type.");
    }
}

