/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.ManagedChannelCustomizer;
import org.axonframework.axonserver.connector.TargetContextResolver;
import org.axonframework.axonserver.connector.command.AxonServerCommandBus;
import org.axonframework.axonserver.connector.command.CommandLoadFactorProvider;
import org.axonframework.axonserver.connector.command.CommandPriorityCalculator;
import org.axonframework.axonserver.connector.event.axon.AxonServerEventStore;
import org.axonframework.axonserver.connector.event.axon.AxonServerEventStoreFactory;
import org.axonframework.axonserver.connector.event.axon.EventProcessorInfoConfiguration;
import org.axonframework.axonserver.connector.query.AxonServerQueryBus;
import org.axonframework.axonserver.connector.query.QueryPriorityCalculator;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandBusSpanFactory;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.LoggingDuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.distributed.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.eventhandling.EventBusSpanFactory;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.inmemory.InMemoryTokenStore;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryBusSpanFactory;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectorConfigurerModule
implements ConfigurerModule {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectorConfigurerModule.class);

    public void configureModule(@Nonnull Configurer configurer) {
        configurer.registerComponent(AxonServerConfiguration.class, c -> new AxonServerConfiguration());
        configurer.registerComponent(AxonServerConnectionManager.class, this::buildAxonServerConnectionManager);
        configurer.registerComponent(ManagedChannelCustomizer.class, c -> ManagedChannelCustomizer.identity());
        configurer.configureEventStore(this::buildEventStore);
        configurer.configureCommandBus(this::buildCommandBus);
        configurer.configureQueryBus(this::buildQueryBus);
        configurer.registerModule((ModuleConfiguration)new EventProcessorInfoConfiguration());
        configurer.registerComponent(TokenStore.class, c -> {
            logger.warn("BEWARE! Falling back to an in-memory token store. It is highly recommended to configure a persistent implementation, based on the activity of the handler.");
            return new InMemoryTokenStore();
        });
        configurer.registerComponent(TargetContextResolver.class, configuration -> TargetContextResolver.noOp());
        configurer.registerComponent(AxonServerEventStoreFactory.class, this::buildEventStoreFactory);
    }

    private AxonServerConnectionManager buildAxonServerConnectionManager(Configuration c) {
        return AxonServerConnectionManager.builder().axonServerConfiguration((AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class)).tagsConfiguration((TagsConfiguration)c.getComponent(TagsConfiguration.class, TagsConfiguration::new)).channelCustomizer((UnaryOperator)c.getComponent(ManagedChannelCustomizer.class)).build();
    }

    private AxonServerEventStore buildEventStore(Configuration c) {
        return AxonServerEventStore.builder().configuration((AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class)).platformConnectionManager((AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class)).messageMonitor(c.messageMonitor(AxonServerEventStore.class, "eventStore")).snapshotSerializer(c.serializer()).eventSerializer(c.eventSerializer()).snapshotFilter(c.snapshotFilter()).upcasterChain((EventUpcaster)c.upcasterChain()).spanFactory((EventBusSpanFactory)c.getComponent(EventBusSpanFactory.class)).build();
    }

    private AxonServerCommandBus buildCommandBus(Configuration c) {
        SimpleCommandBus localSegment = SimpleCommandBus.builder().duplicateCommandHandlerResolver((DuplicateCommandHandlerResolver)c.getComponent(DuplicateCommandHandlerResolver.class, LoggingDuplicateCommandHandlerResolver::instance)).messageMonitor(c.messageMonitor(CommandBus.class, "localCommandBus")).transactionManager((TransactionManager)c.getComponent(TransactionManager.class, NoTransactionManager::instance)).spanFactory((CommandBusSpanFactory)c.getComponent(CommandBusSpanFactory.class)).build();
        return AxonServerCommandBus.builder().axonServerConnectionManager((AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class)).configuration((AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class)).localSegment((CommandBus)localSegment).serializer(c.messageSerializer()).routingStrategy((RoutingStrategy)c.getComponent(RoutingStrategy.class, AnnotationRoutingStrategy::defaultStrategy)).priorityCalculator((CommandPriorityCalculator)c.getComponent(CommandPriorityCalculator.class, CommandPriorityCalculator::defaultCommandPriorityCalculator)).loadFactorProvider((CommandLoadFactorProvider)c.getComponent(CommandLoadFactorProvider.class, () -> command -> 100)).targetContextResolver((TargetContextResolver)c.getComponent(TargetContextResolver.class)).spanFactory((CommandBusSpanFactory)c.getComponent(CommandBusSpanFactory.class)).build();
    }

    private QueryBus buildQueryBus(Configuration c) {
        SimpleQueryBus localSegment = SimpleQueryBus.builder().transactionManager((TransactionManager)c.getComponent(TransactionManager.class, NoTransactionManager::instance)).errorHandler((QueryInvocationErrorHandler)c.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter(c.queryUpdateEmitter()).spanFactory((QueryBusSpanFactory)c.getComponent(QueryBusSpanFactory.class)).messageMonitor(c.messageMonitor(QueryBus.class, "localQueryBus")).build();
        return AxonServerQueryBus.builder().axonServerConnectionManager((AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class)).configuration((AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class)).localSegment((QueryBus)localSegment).updateEmitter(c.queryUpdateEmitter()).messageSerializer(c.messageSerializer()).genericSerializer(c.serializer()).priorityCalculator((QueryPriorityCalculator)c.getComponent(QueryPriorityCalculator.class, QueryPriorityCalculator::defaultQueryPriorityCalculator)).targetContextResolver((TargetContextResolver)c.getComponent(TargetContextResolver.class)).spanFactory((QueryBusSpanFactory)c.getComponent(QueryBusSpanFactory.class)).build();
    }

    private AxonServerEventStoreFactory buildEventStoreFactory(Configuration config) {
        return AxonServerEventStoreFactory.builder().configuration((AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class)).connectionManager((AxonServerConnectionManager)config.getComponent(AxonServerConnectionManager.class)).snapshotSerializer(config.serializer()).eventSerializer(config.eventSerializer()).snapshotFilter(config.snapshotFilter()).upcasterChain((EventUpcaster)config.upcasterChain()).messageMonitor(config.messageMonitor(AxonServerEventStore.class, "eventStore")).spanFactory((EventBusSpanFactory)config.getComponent(EventBusSpanFactory.class)).build();
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

