/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.Registration;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;

public class DispatchInterceptors<M extends Message<?>> {
    private final List<MessageDispatchInterceptor<? super M>> dispatchInterceptors = new CopyOnWriteArrayList<MessageDispatchInterceptor<? super M>>();

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super M> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    public <T extends M> T intercept(T message) {
        Object messageToDispatch = message;
        for (MessageDispatchInterceptor<? super M> messageDispatchInterceptor : this.dispatchInterceptors) {
            messageToDispatch = messageDispatchInterceptor.handle(messageToDispatch);
        }
        return messageToDispatch;
    }
}

