/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import java.time.Instant;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.CachingSupplier;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.serialization.upcasting.event.UpcastedEventRepresentation;

public class InitialEventRepresentation
implements IntermediateEventRepresentation {
    private final SerializedObject<Object> data;
    private final SerializedType type;
    private final Class<?> contentType;
    private final LazyDeserializingObject<MetaData> metaData;
    private final String eventIdentifier;
    private final Supplier<Instant> timestamp;
    private final String aggregateType;
    private final String aggregateIdentifier;
    private final Long sequenceNumber;
    private final TrackingToken trackingToken;
    private final Serializer serializer;

    public InitialEventRepresentation(EventData<?> eventData, Serializer serializer) {
        this.data = eventData.getPayload();
        this.type = this.data.getType();
        this.contentType = this.data.getContentType();
        this.metaData = new LazyDeserializingObject(eventData.getMetaData(), serializer);
        this.eventIdentifier = eventData.getEventIdentifier();
        this.timestamp = CachingSupplier.of(eventData::getTimestamp);
        if (eventData instanceof DomainEventData) {
            DomainEventData domainEventData = (DomainEventData)eventData;
            this.aggregateType = domainEventData.getType();
            this.aggregateIdentifier = domainEventData.getAggregateIdentifier();
            this.sequenceNumber = domainEventData.getSequenceNumber();
        } else {
            this.aggregateType = null;
            this.aggregateIdentifier = null;
            this.sequenceNumber = null;
        }
        this.trackingToken = eventData instanceof TrackedEventData ? ((TrackedEventData)eventData).trackingToken() : null;
        this.serializer = serializer;
    }

    @Override
    public <T> IntermediateEventRepresentation upcast(SerializedType outputType, Class<T> expectedRepresentationType, Function<T, T> upcastFunction, Function<MetaData, MetaData> metaDataUpcastFunction) {
        return new UpcastedEventRepresentation<T>(outputType, this, upcastFunction, metaDataUpcastFunction, expectedRepresentationType, this.serializer.getConverter());
    }

    @Override
    public SerializedType getType() {
        return this.type;
    }

    @Override
    public SerializedObject<?> getData() {
        return this.data;
    }

    @Override
    public <D> SerializedObject<D> getData(Class<D> requiredType) {
        return this.serializer.getConverter().convert(this.data, requiredType);
    }

    @Override
    public Class<?> getContentType() {
        return this.contentType;
    }

    @Override
    public String getMessageIdentifier() {
        return this.eventIdentifier;
    }

    @Override
    public Optional<String> getAggregateType() {
        return Optional.ofNullable(this.aggregateType);
    }

    @Override
    public Optional<String> getAggregateIdentifier() {
        return Optional.ofNullable(this.aggregateIdentifier);
    }

    @Override
    public Optional<Long> getSequenceNumber() {
        return Optional.ofNullable(this.sequenceNumber);
    }

    @Override
    public Optional<TrackingToken> getTrackingToken() {
        return Optional.ofNullable(this.trackingToken);
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp.get();
    }

    @Override
    public LazyDeserializingObject<MetaData> getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean canConvertDataTo(Class<?> requiredType) {
        return this.serializer.getConverter().canConvert(this.data.getContentType(), requiredType);
    }
}

