/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;

public class QuerySubscription<R> {
    private final Type responseType;
    private final MessageHandler<? super QueryMessage<?, R>> queryHandler;

    public QuerySubscription(@Nonnull Type responseType, @Nonnull MessageHandler<? super QueryMessage<?, R>> queryHandler) {
        this.responseType = responseType;
        this.queryHandler = queryHandler;
    }

    public Type getResponseType() {
        return this.responseType;
    }

    public boolean canHandle(@Nonnull ResponseType<?> queryResponseType) {
        return queryResponseType.matches(this.responseType);
    }

    public MessageHandler<? super QueryMessage<?, R>> getQueryHandler() {
        return this.queryHandler;
    }

    public int hashCode() {
        return Objects.hash(this.responseType, this.queryHandler);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySubscription other = (QuerySubscription)obj;
        return Objects.equals(this.responseType, other.responseType) && Objects.equals(this.queryHandler, other.queryHandler);
    }
}

