/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.messaging.MessageDispatchInterceptorSupport;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.reactivestreams.Publisher;
import reactor.util.concurrent.Queues;

public interface QueryGateway
extends MessageDispatchInterceptorSupport<QueryMessage<?, ?>> {
    default public <R, Q> CompletableFuture<R> query(@Nonnull Q query, @Nonnull Class<R> responseType) {
        return this.query(QueryMessage.queryName(query), query, responseType);
    }

    default public <R, Q> CompletableFuture<R> query(@Nonnull String queryName, @Nonnull Q query, @Nonnull Class<R> responseType) {
        return this.query(queryName, query, ResponseTypes.instanceOf(responseType));
    }

    default public <R, Q> CompletableFuture<R> query(@Nonnull Q query, @Nonnull ResponseType<R> responseType) {
        return this.query(QueryMessage.queryName(query), query, responseType);
    }

    public <R, Q> CompletableFuture<R> query(@Nonnull String var1, @Nonnull Q var2, @Nonnull ResponseType<R> var3);

    default public <R, Q> Publisher<R> streamingQuery(Q query, Class<R> responseType) {
        return this.streamingQuery(QueryMessage.queryName(query), query, responseType);
    }

    public <R, Q> Publisher<R> streamingQuery(String var1, Q var2, Class<R> var3);

    default public <R, Q> Stream<R> scatterGather(@Nonnull Q query, @Nonnull ResponseType<R> responseType, long timeout, @Nonnull TimeUnit timeUnit) {
        return this.scatterGather(QueryMessage.queryName(query), query, responseType, timeout, timeUnit);
    }

    public <R, Q> Stream<R> scatterGather(@Nonnull String var1, @Nonnull Q var2, @Nonnull ResponseType<R> var3, long var4, @Nonnull TimeUnit var6);

    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull Q query, @Nonnull Class<I> initialResponseType, @Nonnull Class<U> updateResponseType) {
        return this.subscriptionQuery(QueryMessage.queryName(query), query, initialResponseType, updateResponseType);
    }

    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull String queryName, @Nonnull Q query, @Nonnull Class<I> initialResponseType, @Nonnull Class<U> updateResponseType) {
        return this.subscriptionQuery(queryName, query, ResponseTypes.instanceOf(initialResponseType), ResponseTypes.instanceOf(updateResponseType));
    }

    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull Q query, @Nonnull ResponseType<I> initialResponseType, @Nonnull ResponseType<U> updateResponseType) {
        return this.subscriptionQuery(QueryMessage.queryName(query), query, initialResponseType, updateResponseType);
    }

    @Deprecated
    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull String queryName, @Nonnull Q query, @Nonnull ResponseType<I> initialResponseType, @Nonnull ResponseType<U> updateResponseType, @Nullable SubscriptionQueryBackpressure backpressure) {
        return this.subscriptionQuery(queryName, query, initialResponseType, updateResponseType, backpressure, Queues.SMALL_BUFFER_SIZE);
    }

    default public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull String queryName, @Nonnull Q query, @Nonnull ResponseType<I> initialResponseType, @Nonnull ResponseType<U> updateResponseType) {
        return this.subscriptionQuery(queryName, query, initialResponseType, updateResponseType, Queues.SMALL_BUFFER_SIZE);
    }

    @Deprecated
    public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull String var1, @Nonnull Q var2, @Nonnull ResponseType<I> var3, @Nonnull ResponseType<U> var4, @Nullable SubscriptionQueryBackpressure var5, int var6);

    public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull String var1, @Nonnull Q var2, @Nonnull ResponseType<I> var3, @Nonnull ResponseType<U> var4, int var5);
}

