/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.StringUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.DeadLetterQueueOverflowException;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.NoSuchDeadLetterException;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySequencedDeadLetterQueue<M extends Message<?>>
implements SequencedDeadLetterQueue<M> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Deque<DeadLetter<? extends M>>> deadLetters = new ConcurrentHashMap<String, Deque<DeadLetter<? extends M>>>();
    private final Set<String> takenSequences = new ConcurrentSkipListSet<String>();
    private final int maxSequences;
    private final int maxSequenceSize;

    protected InMemorySequencedDeadLetterQueue(Builder<M> builder) {
        builder.validate();
        this.maxSequences = ((Builder)builder).maxSequences;
        this.maxSequenceSize = ((Builder)builder).maxSequenceSize;
    }

    public static <M extends Message<?>> Builder<M> builder() {
        return new Builder();
    }

    public static <M extends Message<?>> InMemorySequencedDeadLetterQueue<M> defaultQueue() {
        return InMemorySequencedDeadLetterQueue.builder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(@Nonnull Object sequenceIdentifier, @Nonnull DeadLetter<? extends M> letter) throws DeadLetterQueueOverflowException {
        if (this.isFull(sequenceIdentifier)) {
            throw new DeadLetterQueueOverflowException(sequenceIdentifier);
        }
        if (logger.isDebugEnabled()) {
            Optional<Cause> optionalCause = letter.cause();
            if (optionalCause.isPresent()) {
                logger.debug("Adding dead letter with message id [{}] because [{}].", (Object)letter.message().getIdentifier(), (Object)optionalCause.get());
            } else {
                logger.debug("Adding dead letter with message id [{}] because the sequence identifier [{}] is already present.", (Object)letter.message().getIdentifier(), sequenceIdentifier);
            }
        }
        Map<String, Deque<DeadLetter<? extends M>>> map = this.deadLetters;
        synchronized (map) {
            this.deadLetters.computeIfAbsent(InMemorySequencedDeadLetterQueue.toIdentifier(sequenceIdentifier), id -> new ConcurrentLinkedDeque()).addLast(letter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict(DeadLetter<? extends M> letter) {
        Optional<Map.Entry> optionalSequence = this.deadLetters.entrySet().stream().filter(sequence -> ((Deque)sequence.getValue()).remove(letter)).findFirst();
        if (optionalSequence.isPresent()) {
            Map<String, Deque<DeadLetter<? extends M>>> map = this.deadLetters;
            synchronized (map) {
                String sequenceId = (String)optionalSequence.get().getKey();
                if (this.deadLetters.get(sequenceId).isEmpty()) {
                    logger.trace("Sequence with id [{}] is empty and will be removed.", (Object)sequenceId);
                    this.deadLetters.remove(sequenceId);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Evicted letter with message id [{}] for sequence id [{}].", (Object)letter.message().getIdentifier(), (Object)sequenceId);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Cannot evict letter with message id [{}] as it could not be found in this queue.", (Object)letter.message().getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requeue(@Nonnull DeadLetter<? extends M> letter, @Nonnull UnaryOperator<DeadLetter<? extends M>> letterUpdater) throws NoSuchDeadLetterException {
        Optional<Map.Entry> optionalSequence = this.deadLetters.entrySet().stream().filter(sequence -> ((Deque)sequence.getValue()).remove(letter)).findFirst();
        if (optionalSequence.isPresent()) {
            Map<String, Deque<DeadLetter<? extends M>>> map = this.deadLetters;
            synchronized (map) {
                String sequenceId = (String)optionalSequence.get().getKey();
                this.deadLetters.get(sequenceId).addFirst((DeadLetter<M>)letterUpdater.apply(letter.markTouched()));
                if (logger.isTraceEnabled()) {
                    logger.trace("Requeued letter [{}] for sequence [{}].", (Object)letter.message().getIdentifier(), (Object)sequenceId);
                }
            }
        } else {
            throw new NoSuchDeadLetterException("Cannot requeue [" + letter.message().getIdentifier() + "] since there is not matching entry in this queue.");
        }
    }

    @Override
    public boolean contains(@Nonnull Object sequenceIdentifier) {
        if (logger.isDebugEnabled()) {
            logger.debug("Validating existence of sequence identifier [{}].", sequenceIdentifier);
        }
        return this.contains(InMemorySequencedDeadLetterQueue.toIdentifier(sequenceIdentifier));
    }

    @Override
    public Iterable<DeadLetter<? extends M>> deadLetterSequence(@Nonnull Object sequenceIdentifier) {
        String identifier = InMemorySequencedDeadLetterQueue.toIdentifier(sequenceIdentifier);
        return this.contains(identifier) ? new ArrayList(this.deadLetters.get(identifier)) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(String identifier) {
        Map<String, Deque<DeadLetter<? extends M>>> map = this.deadLetters;
        synchronized (map) {
            return this.deadLetters.containsKey(identifier);
        }
    }

    @Override
    public Iterable<Iterable<DeadLetter<? extends M>>> deadLetters() {
        return new ArrayList<Iterable<DeadLetter<? extends M>>>(this.deadLetters.values());
    }

    @Override
    public boolean isFull(@Nonnull Object sequenceIdentifier) {
        String identifier = InMemorySequencedDeadLetterQueue.toIdentifier(sequenceIdentifier);
        return this.maximumNumberOfSequencesReached(identifier) || this.maximumSequenceSizeReached(identifier);
    }

    private boolean maximumNumberOfSequencesReached(String identifier) {
        return !this.deadLetters.containsKey(identifier) && this.deadLetters.keySet().size() >= this.maxSequences;
    }

    private boolean maximumSequenceSizeReached(String identifier) {
        return this.deadLetters.containsKey(identifier) && this.deadLetters.get(identifier).size() >= this.maxSequenceSize;
    }

    @Override
    public long size() {
        return this.deadLetters.values().stream().mapToLong(Deque::size).sum();
    }

    @Override
    public long sequenceSize(@Nonnull Object sequenceIdentifier) {
        String identifier = InMemorySequencedDeadLetterQueue.toIdentifier(sequenceIdentifier);
        return this.contains(identifier) ? (long)this.deadLetters.get(identifier).size() : 0L;
    }

    private static String toIdentifier(Object sequenceIdentifier) {
        return sequenceIdentifier instanceof String ? (String)sequenceIdentifier : Integer.toString(sequenceIdentifier.hashCode());
    }

    @Override
    public long amountOfSequences() {
        return this.deadLetters.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(@Nonnull Predicate<DeadLetter<? extends M>> sequenceFilter, @Nonnull Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        if (this.deadLetters.isEmpty()) {
            logger.debug("Received a request to process dead letters but there are none.");
            return false;
        }
        logger.debug("Received a request to process matching dead letters.");
        Map<String, DeadLetter<M>> sequenceIdsToLetter = this.deadLetters.entrySet().stream().filter(entry -> !this.takenSequences.contains(entry.getKey())).filter(sequence -> sequenceFilter.test((DeadLetter)((Deque)sequence.getValue()).getFirst())).collect(Collectors.toMap(Map.Entry::getKey, entry -> (DeadLetter)((Deque)entry.getValue()).getFirst()));
        if (sequenceIdsToLetter.isEmpty()) {
            logger.debug("Received a request to process dead letters but there are no sequences matching the filter.");
            return false;
        }
        String sequenceId = this.getLastTouchedSequence(sequenceIdsToLetter);
        boolean freshlyTaken = this.takenSequences.add(sequenceId);
        while (sequenceId != null && !freshlyTaken) {
            sequenceIdsToLetter.remove(sequenceId);
            sequenceId = this.getLastTouchedSequence(sequenceIdsToLetter);
            freshlyTaken = this.takenSequences.add(sequenceId);
        }
        if (StringUtils.emptyOrNull(sequenceId)) {
            logger.debug("Received a request to process dead letters but there are none left to process.");
            return false;
        }
        try {
            while (this.deadLetters.get(sequenceId) != null && !this.deadLetters.get(sequenceId).isEmpty()) {
                DeadLetter<? extends M> letter = this.deadLetters.get(sequenceId).getFirst();
                EnqueueDecision decision = processingTask.apply(letter);
                if (decision.shouldEnqueue()) {
                    this.requeue(letter, l -> decision.withDiagnostics((DeadLetter)l).withCause(decision.enqueueCause().orElse(null)));
                    boolean bl = false;
                    return bl;
                }
                this.evict(letter);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.takenSequences.remove(sequenceId);
        }
    }

    private String getLastTouchedSequence(Map<String, DeadLetter<? extends M>> sequenceIdsToLetter) {
        Instant current = GenericDeadLetter.clock.instant();
        long lastTouchedSequence = Long.MAX_VALUE;
        String lastTouchedSequenceId = null;
        for (Map.Entry<String, DeadLetter<M>> sequenceIdToLetter : sequenceIdsToLetter.entrySet()) {
            long lastTouched;
            DeadLetter<M> letter = sequenceIdToLetter.getValue();
            if (letter == null || (lastTouched = letter.lastTouched().toEpochMilli()) > current.toEpochMilli() || lastTouched >= lastTouchedSequence) continue;
            lastTouchedSequence = lastTouched;
            lastTouchedSequenceId = sequenceIdToLetter.getKey();
        }
        return lastTouchedSequenceId;
    }

    @Override
    public void clear() {
        ArrayList<String> sequencesToClear = new ArrayList<String>(this.deadLetters.keySet());
        sequencesToClear.forEach(sequenceId -> {
            this.deadLetters.get(sequenceId).clear();
            this.deadLetters.remove(sequenceId);
            logger.info("Cleared out all dead letters for sequence [{}].", sequenceId);
        });
    }

    public static class Builder<M extends Message<?>> {
        private int maxSequences = 1024;
        private int maxSequenceSize = 1024;

        public Builder<M> maxSequences(int maxSequences) {
            BuilderUtils.assertStrictPositive(maxSequences, "The maximum number of sequences should be a strictly positive number");
            this.maxSequences = maxSequences;
            return this;
        }

        public Builder<M> maxSequenceSize(int maxSequenceSize) {
            BuilderUtils.assertStrictPositive(maxSequenceSize, "The maximum number of dead letters in a sequence should be a strictly positive number");
            this.maxSequenceSize = maxSequenceSize;
            return this;
        }

        public InMemorySequencedDeadLetterQueue<M> build() {
            return new InMemorySequencedDeadLetterQueue(this);
        }

        protected void validate() {
        }
    }
}

