/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.concurrent.Callable;
import org.axonframework.common.Assert;
import org.axonframework.common.Priority;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

@Priority(value=0x7FFFFFFF)
public class InterceptorChainParameterResolverFactory
implements ParameterResolverFactory,
ParameterResolver<InterceptorChain> {
    private static final String INTERCEPTOR_CHAIN_EMITTER_KEY = InterceptorChain.class.getName();
    private static final ThreadLocal<InterceptorChain> CURRENT = new ThreadLocal();

    @Deprecated
    public static void initialize(InterceptorChain interceptorChain) {
        Assert.state(CurrentUnitOfWork.isStarted(), () -> "An active Unit of Work is required for injecting interceptor chain");
        CurrentUnitOfWork.get().resources().put(INTERCEPTOR_CHAIN_EMITTER_KEY, interceptorChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R callWithInterceptorChain(InterceptorChain interceptorChain, Callable<R> action) throws Exception {
        InterceptorChain previous = CURRENT.get();
        CURRENT.set(interceptorChain);
        try {
            R r = action.call();
            return r;
        }
        finally {
            if (previous == null) {
                CURRENT.remove();
            } else {
                CURRENT.set(previous);
            }
        }
    }

    public static InterceptorChain currentInterceptorChain() {
        return CURRENT.get();
    }

    @Override
    public InterceptorChain resolveParameterValue(Message<?> message) {
        InterceptorChain interceptorChain = CURRENT.get();
        if (interceptorChain != null) {
            return interceptorChain;
        }
        return CurrentUnitOfWork.map(uow -> (InterceptorChain)uow.getResource(INTERCEPTOR_CHAIN_EMITTER_KEY)).orElseThrow(() -> new IllegalStateException("InterceptorChain should have been injected"));
    }

    @Override
    public boolean matches(Message<?> message) {
        return CURRENT.get() != null || CurrentUnitOfWork.isStarted() && CurrentUnitOfWork.get().resources().containsKey(INTERCEPTOR_CHAIN_EMITTER_KEY);
    }

    @Override
    public ParameterResolver<InterceptorChain> createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        if (InterceptorChain.class.equals(parameters[parameterIndex].getType())) {
            return this;
        }
        return null;
    }
}

