/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.interceptors;

import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoggingInterceptor
implements MessageDispatchInterceptor<EventMessage<?>> {
    private final Logger logger;

    public EventLoggingInterceptor() {
        this(EventLoggingInterceptor.class.getName());
    }

    public EventLoggingInterceptor(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    @Override
    @Nonnull
    public BiFunction<Integer, EventMessage<?>, EventMessage<?>> handle(@Nonnull List<? extends EventMessage<?>> messages) {
        StringBuilder sb = new StringBuilder(String.format("Events published: [%s]", messages.stream().map(m -> m.getPayloadType().getSimpleName()).collect(Collectors.joining(", "))));
        CurrentUnitOfWork.ifStarted(unitOfWork -> {
            Object message = unitOfWork.getMessage();
            if (message == null) {
                sb.append(" while processing an operation not tied to an incoming message");
            } else {
                sb.append(String.format(" while processing a [%s]", message.getPayloadType().getSimpleName()));
            }
            ExecutionResult executionResult = unitOfWork.getExecutionResult();
            if (executionResult != null) {
                if (executionResult.isExceptionResult()) {
                    Throwable exception = executionResult.getExceptionResult();
                    exception = exception instanceof ExecutionException ? exception.getCause() : exception;
                    sb.append(String.format(" which failed with a [%s]", exception.getClass().getSimpleName()));
                } else if (executionResult.getResult() != null) {
                    sb.append(String.format(" which yielded a [%s] return value", executionResult.getResult().getClass().getSimpleName()));
                }
            }
        });
        this.logger.info(sb.toString());
        return (i, m) -> m;
    }
}

