/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import org.axonframework.common.BuilderUtils;
import org.axonframework.deadline.DeadlineManagerSpanFactory;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;

public class DefaultDeadlineManagerSpanFactory
implements DeadlineManagerSpanFactory {
    private final SpanFactory spanFactory;
    private final String deadlineIdAttribute;
    private final String scopeAttribute;

    protected DefaultDeadlineManagerSpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
        this.deadlineIdAttribute = builder.builderDeadlineIdAttribute;
        this.scopeAttribute = builder.builderScopeAttribute;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Span createScheduleSpan(String deadlineName, String deadlineId, DeadlineMessage<?> deadlineMessage) {
        return this.spanFactory.createDispatchSpan(() -> "DeadlineManager.scheduleDeadline(" + deadlineName + ")", deadlineMessage, new Message[0]).addAttribute(this.deadlineIdAttribute, deadlineId);
    }

    @Override
    public Span createCancelScheduleSpan(String deadlineName, String deadlineId) {
        return this.spanFactory.createInternalSpan(() -> "DeadlineManager.cancelDeadline(" + deadlineName + ")").addAttribute(this.deadlineIdAttribute, deadlineId);
    }

    @Override
    public Span createCancelAllSpan(String deadlineName) {
        return this.spanFactory.createInternalSpan(() -> "DeadlineManager.cancelAllDeadlines(" + deadlineName + ")");
    }

    @Override
    public Span createCancelAllWithinScopeSpan(String deadlineName, ScopeDescriptor scopeDescriptor) {
        return this.spanFactory.createInternalSpan(() -> "DeadlineManager.cancelAllWithinScope(" + deadlineName + ")").addAttribute(this.scopeAttribute, scopeDescriptor.scopeDescription());
    }

    @Override
    public Span createExecuteSpan(String deadlineName, String deadlineId, DeadlineMessage<?> deadlineMessage) {
        return this.spanFactory.createLinkedHandlerSpan(() -> "DeadlineManager.executeDeadline(" + deadlineName + ")", deadlineMessage, new Message[0]).addAttribute(this.deadlineIdAttribute, deadlineId);
    }

    @Override
    public <T> DeadlineMessage<T> propagateContext(DeadlineMessage<T> eventMessage) {
        return this.spanFactory.propagateContext(eventMessage);
    }

    public static class Builder {
        private SpanFactory builderSpanFactory;
        private String builderDeadlineIdAttribute = "axon.deadlineId";
        private String builderScopeAttribute = "axon.deadlineScope";

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        public Builder deadlineIdAttribute(String deadlineIdAttribute) {
            BuilderUtils.assertNonEmpty(deadlineIdAttribute, "deadlineIdAttribute may not be null");
            this.builderDeadlineIdAttribute = deadlineIdAttribute;
            return this;
        }

        public Builder scopeAttribute(String scopeAttribute) {
            BuilderUtils.assertNonEmpty(scopeAttribute, "scopeAttribute may not be null");
            this.builderScopeAttribute = scopeAttribute;
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonEmpty(this.builderDeadlineIdAttribute, "deadlineIdAttribute may not be null");
            BuilderUtils.assertNonEmpty(this.builderScopeAttribute, "scopeAttribute may not be null");
            BuilderUtils.assertNonNull(this.builderSpanFactory, "spanFactory may not be null");
        }

        public DefaultDeadlineManagerSpanFactory build() {
            return new DefaultDeadlineManagerSpanFactory(this);
        }
    }
}

