/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.messaging.MessageDispatchInterceptorSupport;
import org.axonframework.messaging.MessageHandlerInterceptorSupport;
import org.axonframework.messaging.Scope;
import org.axonframework.messaging.ScopeDescriptor;

public interface DeadlineManager
extends MessageDispatchInterceptorSupport<DeadlineMessage<?>>,
MessageHandlerInterceptorSupport<DeadlineMessage<?>> {
    default public String schedule(@Nonnull Instant triggerDateTime, @Nonnull String deadlineName) {
        return this.schedule(triggerDateTime, deadlineName, null);
    }

    default public String schedule(@Nonnull Instant triggerDateTime, @Nonnull String deadlineName, @Nullable Object messageOrPayload) {
        return this.schedule(triggerDateTime, deadlineName, messageOrPayload, Scope.describeCurrentScope());
    }

    public String schedule(@Nonnull Instant var1, @Nonnull String var2, @Nullable Object var3, @Nonnull ScopeDescriptor var4);

    default public String schedule(@Nonnull Duration triggerDuration, @Nonnull String deadlineName) {
        return this.schedule(triggerDuration, deadlineName, null);
    }

    default public String schedule(@Nonnull Duration triggerDuration, @Nonnull String deadlineName, @Nullable Object messageOrPayload) {
        return this.schedule(triggerDuration, deadlineName, messageOrPayload, Scope.describeCurrentScope());
    }

    default public String schedule(@Nonnull Duration triggerDuration, @Nonnull String deadlineName, @Nullable Object messageOrPayload, @Nonnull ScopeDescriptor deadlineScope) {
        return this.schedule(Instant.now().plus(triggerDuration), deadlineName, messageOrPayload, deadlineScope);
    }

    public void cancelSchedule(@Nonnull String var1, @Nonnull String var2);

    public void cancelAll(@Nonnull String var1);

    default public void cancelAllWithinScope(@Nonnull String deadlineName) {
        this.cancelAllWithinScope(deadlineName, Scope.describeCurrentScope());
    }

    public void cancelAllWithinScope(@Nonnull String var1, @Nonnull ScopeDescriptor var2);

    default public void shutdown() {
    }
}

