/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.callbacks;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;

public class FutureCallback<C, R>
extends CompletableFuture<CommandResultMessage<? extends R>>
implements CommandCallback<C, R> {
    @Override
    public void onResult(@Nonnull CommandMessage<? extends C> commandMessage, @Nonnull CommandResultMessage<? extends R> commandResultMessage) {
        super.complete(commandResultMessage);
    }

    public CommandResultMessage<? extends R> getResult() {
        try {
            return (CommandResultMessage)this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new GenericCommandResultMessage<Object>(null);
        }
        catch (ExecutionException e) {
            return GenericCommandResultMessage.asCommandResultMessage(e.getCause());
        }
        catch (Exception e) {
            return GenericCommandResultMessage.asCommandResultMessage(e);
        }
    }

    public CommandResultMessage<? extends R> getResult(long timeout, TimeUnit unit) {
        try {
            return (CommandResultMessage)this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new GenericCommandResultMessage(e);
        }
        catch (ExecutionException e) {
            return GenericCommandResultMessage.asCommandResultMessage(e.getCause());
        }
        catch (Exception e) {
            return GenericCommandResultMessage.asCommandResultMessage(e);
        }
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) {
        try {
            this.get(timeout, unit);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }
}

