/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.function.Predicate;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;

public class FilteringDomainEventStream
implements DomainEventStream {
    private final DomainEventStream delegate;
    private final Predicate<? super DomainEventMessage<?>> filter;
    private Long lastSequenceNumber;

    public FilteringDomainEventStream(DomainEventStream delegate, Predicate<? super DomainEventMessage<?>> filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public DomainEventMessage<?> peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.delegate.peek();
    }

    @Override
    public boolean hasNext() {
        if (!this.delegate.hasNext()) {
            return false;
        }
        DomainEventMessage<?> peeked = this.delegate.peek();
        while (!this.filter.test(peeked)) {
            this.delegate.next();
            if (this.delegate.hasNext()) {
                peeked = this.delegate.peek();
                continue;
            }
            return false;
        }
        return this.delegate.hasNext();
    }

    @Override
    public DomainEventMessage<?> next() {
        if (!this.hasNext()) {
            return null;
        }
        DomainEventMessage<?> next = this.delegate.next();
        this.lastSequenceNumber = next.getSequenceNumber();
        return next;
    }

    @Override
    public Long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }
}

