/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.proxy.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.awaitility.core.CheckedExceptionRethrower;

class MethodCaller<T>
implements Callable<T> {
    final Object target;
    final Method method;
    final Object[] args;

    public MethodCaller(Object target, Method method, Object[] args) {
        this.target = target;
        this.method = method;
        this.args = args;
        method.setAccessible(true);
    }

    @Override
    public T call() throws InvocationTargetException, IllegalAccessException {
        try {
            return (T)this.method.invoke(this.target, this.args);
        }
        catch (IllegalAccessException e) {
            return (T)CheckedExceptionRethrower.safeRethrow((Throwable)e);
        }
        catch (InvocationTargetException e) {
            return (T)CheckedExceptionRethrower.safeRethrow((Throwable)e.getCause());
        }
    }
}

