/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.inflector;

import org.atteo.evo.inflector.TwoFormInflector;

public class English
extends TwoFormInflector {
    private static final String[] CATEGORY_EX_ICES = new String[]{"codex", "murex", "silex"};
    private static final String[] CATEGORY_IX_ICES = new String[]{"radix", "helix"};
    private static final String[] CATEGORY_UM_A = new String[]{"bacterium", "agendum", "desideratum", "erratum", "stratum", "datum", "ovum", "extremum", "candelabrum"};
    private static final String[] CATEGORY_US_I = new String[]{"alumnus", "alveolus", "bacillus", "bronchus", "locus", "nucleus", "stimulus", "meniscus", "thesaurus"};
    private static final String[] CATEGORY_ON_A = new String[]{"criterion", "perihelion", "aphelion", "phenomenon", "prolegomenon", "noumenon", "organon", "asyndeton", "hyperbaton"};
    private static final String[] CATEGORY_A_AE = new String[]{"alumna", "alga", "vertebra", "persona"};
    private static final String[] CATEGORY_O_OS = new String[]{"albino", "archipelago", "armadillo", "commando", "crescendo", "fiasco", "ditto", "dynamo", "embryo", "ghetto", "guano", "inferno", "jumbo", "lumbago", "magneto", "manifesto", "medico", "octavo", "photo", "pro", "quarto", "canto", "lingo", "generalissimo", "stylo", "rhino", "casino", "auto", "macro", "zero"};
    private static final String[] CATEGORY_O_I = new String[]{"solo", "soprano", "basso", "alto", "contralto", "tempo", "piano", "virtuoso"};
    private static final String[] CATEGORY_EN_INA = new String[]{"stamen", "foramen", "lumen"};
    private static final String[] CATEGORY_A_ATA = new String[]{"anathema", "enema", "oedema", "bema", "enigma", "sarcoma", "carcinoma", "gumma", "schema", "charisma", "lemma", "soma", "diploma", "lymphoma", "stigma", "dogma", "magma", "stoma", "drama", "melisma", "trauma", "edema", "miasma"};
    private static final String[] CATEGORY_IS_IDES = new String[]{"iris", "clitoris"};
    private static final String[] CATEGORY_US_US = new String[]{"apparatus", "impetus", "prospectus", "cantus", "nexus", "sinus", "coitus", "plexus", "status", "hiatus"};
    private static final String[] CATEGORY_NONE_I = new String[]{"afreet", "afrit", "efreet"};
    private static final String[] CATEGORY_NONE_IM = new String[]{"cherub", "goy", "seraph"};
    private static final String[] CATEGORY_EX_EXES = new String[]{"apex", "latex", "vertex", "cortex", "pontifex", "vortex", "index", "simplex"};
    private static final String[] CATEGORY_IX_IXES = new String[]{"appendix"};
    private static final String[] CATEGORY_S_ES = new String[]{"acropolis", "chaos", "lens", "aegis", "cosmos", "mantis", "alias", "dais", "marquis", "asbestos", "digitalis", "metropolis", "atlas", "epidermis", "pathos", "bathos", "ethos", "pelvis", "bias", "gas", "polis", "caddis", "glottis", "rhinoceros", "cannabis", "glottis", "sassafras", "canvas", "ibis", "trellis"};
    private static final String[] CATEGORY_MAN_MANS = new String[]{"human", "Alabaman", "Bahaman", "Burman", "German", "Hiroshiman", "Liman", "Nakayaman", "Oklahoman", "Panaman", "Selman", "Sonaman", "Tacoman", "Yakiman", "Yokohaman", "Yuman"};
    private static English inflector = new English();

    public English() {
        this(MODE.ENGLISH_ANGLICIZED);
    }

    public English(MODE mode) {
        this.uncountable(new String[]{"fish", "ois", "sheep", "deer", "pox", "itis", "bison", "flounder", "pliers", "bream", "gallows", "proceedings", "breeches", "graffiti", "rabies", "britches", "headquarters", "salmon", "carp", "herpes", "scissors", "chassis", "high-jinks", "sea-bass", "clippers", "homework", "series", "cod", "innings", "shears", "contretemps", "jackanapes", "species", "corps", "mackerel", "swine", "debris", "measles", "trout", "diabetes", "mews", "tuna", "djinn", "mumps", "whiting", "eland", "news", "wildebeest", "elk", "pincers", "sugar"});
        this.irregular(new String[][]{{"child", "children"}, {"ephemeris", "ephemerides"}, {"mongoose", "mongoose"}, {"mythos", "mythoi"}, {"soliloquy", "soliloquies"}, {"trilby", "trilbys"}, {"genus", "genera"}, {"quiz", "quizzes"}});
        if (mode == MODE.ENGLISH_ANGLICIZED) {
            this.irregular(new String[][]{{"beef", "beefs"}, {"brother", "brothers"}, {"cow", "cows"}, {"genie", "genies"}, {"money", "moneys"}, {"octopus", "octopuses"}, {"opus", "opuses"}});
        } else if (mode == MODE.ENGLISH_CLASSICAL) {
            this.irregular(new String[][]{{"beef", "beeves"}, {"brother", "brethren"}, {"cos", "kine"}, {"genie", "genii"}, {"money", "monies"}, {"octopus", "octopodes"}, {"opus", "opera"}});
        }
        this.categoryRule(CATEGORY_MAN_MANS, "", "s");
        this.rule(new String[][]{{"man$", "men"}, {"([lm])ouse$", "$1ice"}, {"tooth$", "teeth"}, {"goose$", "geese"}, {"foot$", "feet"}, {"zoon$", "zoa"}, {"([csx])is$", "$1es"}});
        this.categoryRule(CATEGORY_EX_ICES, "ex", "ices");
        this.categoryRule(CATEGORY_IX_ICES, "ix", "ices");
        this.categoryRule(CATEGORY_UM_A, "um", "a");
        this.categoryRule(CATEGORY_ON_A, "on", "a");
        this.categoryRule(CATEGORY_A_AE, "a", "ae");
        if (mode == MODE.ENGLISH_CLASSICAL) {
            this.rule(new String[][]{{"trix$", "trices"}, {"eau$", "eaux"}, {"ieu$", "ieux"}, {"(..[iay])nx$", "$1nges"}});
            this.categoryRule(CATEGORY_EN_INA, "en", "ina");
            this.categoryRule(CATEGORY_A_ATA, "a", "ata");
            this.categoryRule(CATEGORY_IS_IDES, "is", "ides");
            this.categoryRule(CATEGORY_US_US, "", "");
            this.categoryRule(CATEGORY_O_I, "o", "i");
            this.categoryRule(CATEGORY_NONE_I, "", "i");
            this.categoryRule(CATEGORY_NONE_IM, "", "im");
            this.categoryRule(CATEGORY_EX_EXES, "ex", "ices");
            this.categoryRule(CATEGORY_IX_IXES, "ix", "ices");
        }
        this.categoryRule(CATEGORY_US_I, "us", "i");
        this.rule("([cs]h|[zx])$", "$1es");
        this.categoryRule(CATEGORY_S_ES, "", "es");
        this.categoryRule(CATEGORY_IS_IDES, "", "es");
        this.categoryRule(CATEGORY_US_US, "", "es");
        this.rule("(us)$", "$1es");
        this.categoryRule(CATEGORY_A_ATA, "", "s");
        this.rule(new String[][]{{"([cs])h$", "$1hes"}, {"ss$", "sses"}});
        this.rule(new String[][]{{"([aeo]l)f$", "$1ves"}, {"([^d]ea)f$", "$1ves"}, {"(ar)f$", "$1ves"}, {"([nlw]i)fe$", "$1ves"}});
        this.rule(new String[][]{{"([aeiou])y$", "$1ys"}, {"y$", "ies"}});
        this.categoryRule(CATEGORY_O_I, "o", "os");
        this.categoryRule(CATEGORY_O_OS, "o", "os");
        this.rule("([aeiou])o$", "$1os");
        this.rule("o$", "oes");
        this.rule("ulum", "ula");
        this.categoryRule(CATEGORY_A_ATA, "", "es");
        this.rule("s$", "ses");
        this.rule("$", "s");
    }

    @Override
    public String getPlural(String word) {
        return super.getPlural(word);
    }

    public String getPlural(String word, int count) {
        if (count == 1) {
            return word;
        }
        return this.getPlural(word);
    }

    public static String plural(String word) {
        return inflector.getPlural(word);
    }

    public static String plural(String word, int count) {
        return inflector.getPlural(word, count);
    }

    public static void setMode(MODE mode) {
        English newInflector;
        inflector = newInflector = new English(mode);
    }

    public static enum MODE {
        ENGLISH_ANGLICIZED,
        ENGLISH_CLASSICAL;

    }
}

