/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.AbstractJetty9AsyncSupportWithWebSocket;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9AsyncSupportWithWebSocket
extends AbstractJetty9AsyncSupportWithWebSocket {
    private static final Logger logger = LoggerFactory.getLogger(Jetty9AsyncSupportWithWebSocket.class);
    private final WebSocketServerFactory webSocketFactory;

    public Jetty9AsyncSupportWithWebSocket(AtmosphereConfig config) {
        super(config, logger);
        WebSocketPolicy policy = Jetty9AsyncSupportWithWebSocket.GetPolicy(config);
        final WebSocketProcessor webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        this.webSocketFactory = new WebSocketServerFactory(config.getServletContext(), policy){

            public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
                this.setCreator(Jetty9AsyncSupportWithWebSocket.this.buildCreator(request, response, webSocketProcessor));
                return super.acceptWebSocket(request, response);
            }
        };
        try {
            this.webSocketFactory.start();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    @Override
    WebSocketServerFactory getWebSocketFactory() {
        return this.webSocketFactory;
    }
}

