/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.resolver.NameResolver;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.asynchttpclient.Param;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.channel.ChannelPoolPartitioning;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.MiscUtils;
import org.jetbrains.annotations.Nullable;

public class DefaultRequest
implements Request {
    @Nullable
    public final ProxyServer proxyServer;
    private final String method;
    private final Uri uri;
    @Nullable
    private final InetAddress address;
    @Nullable
    private final InetAddress localAddress;
    private final HttpHeaders headers;
    private final List<Cookie> cookies;
    private final byte @Nullable [] byteData;
    @Nullable
    private final List<byte[]> compositeByteData;
    @Nullable
    private final String stringData;
    @Nullable
    private final ByteBuffer byteBufferData;
    @Nullable
    private final InputStream streamData;
    @Nullable
    private final BodyGenerator bodyGenerator;
    private final List<Param> formParams;
    private final List<Part> bodyParts;
    @Nullable
    private final String virtualHost;
    @Nullable
    private final Realm realm;
    @Nullable
    private final File file;
    @Nullable
    private final Boolean followRedirect;
    private final Duration requestTimeout;
    private final Duration readTimeout;
    private final long rangeOffset;
    @Nullable
    private final Charset charset;
    private final ChannelPoolPartitioning channelPoolPartitioning;
    private final NameResolver<InetAddress> nameResolver;
    @Nullable
    private List<Param> queryParams;

    public DefaultRequest(String method, Uri uri, @Nullable InetAddress address, @Nullable InetAddress localAddress, HttpHeaders headers, List<Cookie> cookies, byte @Nullable [] byteData, @Nullable List<byte[]> compositeByteData, @Nullable String stringData, @Nullable ByteBuffer byteBufferData, @Nullable InputStream streamData, @Nullable BodyGenerator bodyGenerator, List<Param> formParams, List<Part> bodyParts, @Nullable String virtualHost, @Nullable ProxyServer proxyServer, @Nullable Realm realm, @Nullable File file, @Nullable Boolean followRedirect, @Nullable Duration requestTimeout, @Nullable Duration readTimeout, long rangeOffset, @Nullable Charset charset, ChannelPoolPartitioning channelPoolPartitioning, NameResolver<InetAddress> nameResolver) {
        this.method = method;
        this.uri = uri;
        this.address = address;
        this.localAddress = localAddress;
        this.headers = headers;
        this.cookies = cookies;
        this.byteData = byteData;
        this.compositeByteData = compositeByteData;
        this.stringData = stringData;
        this.byteBufferData = byteBufferData;
        this.streamData = streamData;
        this.bodyGenerator = bodyGenerator;
        this.formParams = formParams;
        this.bodyParts = bodyParts;
        this.virtualHost = virtualHost;
        this.proxyServer = proxyServer;
        this.realm = realm;
        this.file = file;
        this.followRedirect = followRedirect;
        this.requestTimeout = requestTimeout == null ? Duration.ZERO : requestTimeout;
        this.readTimeout = readTimeout == null ? Duration.ZERO : readTimeout;
        this.rangeOffset = rangeOffset;
        this.charset = charset;
        this.channelPoolPartitioning = channelPoolPartitioning;
        this.nameResolver = nameResolver;
    }

    @Override
    public String getUrl() {
        return this.uri.toUrl();
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    @Override
    @Nullable
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    @Nullable
    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public byte @Nullable [] getByteData() {
        return this.byteData;
    }

    @Override
    @Nullable
    public List<byte[]> getCompositeByteData() {
        return this.compositeByteData;
    }

    @Override
    @Nullable
    public String getStringData() {
        return this.stringData;
    }

    @Override
    @Nullable
    public ByteBuffer getByteBufferData() {
        return this.byteBufferData;
    }

    @Override
    @Nullable
    public InputStream getStreamData() {
        return this.streamData;
    }

    @Override
    @Nullable
    public BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    @Override
    public List<Param> getFormParams() {
        return this.formParams;
    }

    @Override
    public List<Part> getBodyParts() {
        return this.bodyParts;
    }

    @Override
    @Nullable
    public String getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    @Nullable
    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    @Override
    @Nullable
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    @Nullable
    public File getFile() {
        return this.file;
    }

    @Override
    @Nullable
    public Boolean getFollowRedirect() {
        return this.followRedirect;
    }

    @Override
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public long getRangeOffset() {
        return this.rangeOffset;
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public ChannelPoolPartitioning getChannelPoolPartitioning() {
        return this.channelPoolPartitioning;
    }

    @Override
    public NameResolver<InetAddress> getNameResolver() {
        return this.nameResolver;
    }

    @Override
    public List<Param> getQueryParams() {
        if (this.queryParams == null) {
            if (MiscUtils.isNonEmpty(this.uri.getQuery())) {
                this.queryParams = new ArrayList<Param>(1);
                for (String queryStringParam : this.uri.getQuery().split("&")) {
                    int pos = queryStringParam.indexOf(61);
                    if (pos <= 0) {
                        this.queryParams.add(new Param(queryStringParam, null));
                        continue;
                    }
                    this.queryParams.add(new Param(queryStringParam.substring(0, pos), queryStringParam.substring(pos + 1)));
                }
            } else {
                this.queryParams = Collections.emptyList();
            }
        }
        return this.queryParams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUrl());
        sb.append('\t');
        sb.append(this.method);
        sb.append("\theaders:");
        if (!this.headers.isEmpty()) {
            for (Map.Entry header : this.headers) {
                sb.append('\t');
                sb.append((String)header.getKey());
                sb.append(':');
                sb.append((String)header.getValue());
            }
        }
        if (MiscUtils.isNonEmpty(this.formParams)) {
            sb.append("\tformParams:");
            for (Param param : this.formParams) {
                sb.append('\t');
                sb.append(param.getName());
                sb.append(':');
                sb.append(param.getValue());
            }
        }
        return sb.toString();
    }
}

