/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueMember;
import org.asteriskjava.live.InvalidPenaltyException;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.NoSuchInterfaceException;
import org.asteriskjava.live.QueueMemberState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.manager.action.QueuePauseAction;
import org.asteriskjava.manager.action.QueuePenaltyAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;

class AsteriskQueueMemberImpl
extends AbstractLiveObject
implements AsteriskQueueMember {
    private AsteriskQueue queue;
    private QueueMemberState state;
    private String location;
    private Integer penalty;
    private boolean paused;
    private String membership;

    AsteriskQueueMemberImpl(AsteriskServerImpl server, AsteriskQueueImpl queue, String location, QueueMemberState state, boolean paused, Integer penalty, String membership) {
        super(server);
        this.queue = queue;
        this.location = location;
        this.state = state;
        this.penalty = penalty;
        this.paused = paused;
        this.membership = membership;
    }

    @Override
    public AsteriskQueue getQueue() {
        return this.queue;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public QueueMemberState getState() {
        return this.state;
    }

    @Override
    @Deprecated
    public boolean getPaused() {
        return this.isPaused();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void setPaused(boolean paused) throws ManagerCommunicationException, NoSuchInterfaceException {
        this.sendPauseAction(new QueuePauseAction(this.location, this.queue.getName(), paused));
    }

    @Override
    public void setPausedAll(boolean paused) throws ManagerCommunicationException, NoSuchInterfaceException {
        this.sendPauseAction(new QueuePauseAction(this.location, paused));
    }

    private void sendPauseAction(QueuePauseAction action) throws ManagerCommunicationException, NoSuchInterfaceException {
        ManagerResponse response = this.server.sendAction(action);
        if (response instanceof ManagerError) {
            if (action.getQueue() != null) {
                throw new NoSuchInterfaceException("Unable to change paused state for '" + action.getInterface() + "' on '" + action.getQueue() + "': " + response.getMessage());
            }
            throw new NoSuchInterfaceException("Unable to change paused state for '" + action.getInterface() + "' on all queues: " + response.getMessage());
        }
    }

    @Override
    public String getMembership() {
        return this.membership;
    }

    @Override
    public boolean isStatic() {
        return this.membership != null && "static".equals(this.membership);
    }

    @Override
    public boolean isDynamic() {
        return this.membership != null && "dynamic".equals(this.membership);
    }

    @Override
    public Integer getPenalty() {
        return this.penalty;
    }

    @Override
    public void setPenalty(int penalty) throws IllegalArgumentException, ManagerCommunicationException, InvalidPenaltyException {
        if (penalty < 0) {
            throw new IllegalArgumentException("Penalty must not be negative");
        }
        ManagerResponse response = this.server.sendAction(new QueuePenaltyAction(this.location, penalty, this.queue.getName()));
        if (response instanceof ManagerError) {
            throw new InvalidPenaltyException("Unable to set penalty for '" + this.location + "' on '" + this.queue.getName() + "': " + response.getMessage());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AsteriskQueueMember[");
        sb.append("location='").append(this.location).append("'");
        sb.append("state='").append((Object)this.state).append("'");
        sb.append("paused='").append(this.paused).append("'");
        sb.append("membership='").append(this.membership).append("'");
        sb.append("queue='").append(this.queue.getName()).append("'");
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }

    synchronized void stateChanged(QueueMemberState state) {
        QueueMemberState oldState = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)oldState, (Object)state);
    }

    synchronized void penaltyChanged(Integer penalty) {
        Integer oldPenalty = this.penalty;
        this.penalty = penalty;
        this.firePropertyChange("penalty", oldPenalty, penalty);
    }

    synchronized void pausedChanged(boolean paused) {
        boolean oldPaused = this.paused;
        this.paused = paused;
        this.firePropertyChange("paused", oldPaused, paused);
    }
}

