/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.internal;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.guava.error.RangeSetShouldEnclose;
import org.assertj.guava.error.RangeSetShouldEncloseAnyOf;
import org.assertj.guava.error.RangeSetShouldIntersect;
import org.assertj.guava.error.RangeSetShouldIntersectAnyOf;
import org.assertj.guava.error.RangeSetShouldNotEnclose;
import org.assertj.guava.error.RangeSetShouldNotIntersect;
import org.assertj.guava.internal.ErrorMessages;
import org.assertj.guava.util.ExceptionUtils;

public class RangeSets {
    private static final RangeSets INSTANCE = new RangeSets();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static RangeSets instance() {
        return INSTANCE;
    }

    public void assertHasSize(AssertionInfo info, RangeSet<?> actual, int size) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizes(actual, (int)IterableUtil.sizeOf((Iterable)actual.asRanges()), (int)size, (AssertionInfo)info);
    }

    public <T extends Comparable<T>> void assertContains(AssertionInfo info, RangeSet<T> actual, T[] values) {
        this.assertNotNull(info, actual);
        this.failIfNull(values);
        if (actual.isEmpty() && values.length == 0) {
            return;
        }
        this.failIfEmpty(values);
        this.assertRangeSetContainsGivenValues(info, (RangeSet)actual, (Comparable[])values);
    }

    public <T extends Comparable<T>> void assertContainsAll(AssertionInfo info, RangeSet<T> actual, Iterable<T> values) {
        this.assertNotNull(info, actual);
        this.failIfNull(values);
        if (actual.isEmpty() && !values.iterator().hasNext()) {
            return;
        }
        this.failIfEmpty(values);
        this.assertRangeSetContainsGivenValues(info, actual, (Comparable[])IterableUtil.toArray(values, Comparable.class));
    }

    private void assertRangeSetContainsGivenValues(AssertionInfo info, RangeSet actual, Comparable[] values) {
        List elementsNotFound = Arrays.stream(values).filter(value -> !actual.contains(value)).collect(Collectors.toList());
        if (!elementsNotFound.isEmpty()) {
            throw this.failures.failure(info, ShouldContain.shouldContain((Object)actual, (Object)values, elementsNotFound));
        }
    }

    public <T extends Comparable<T>> void assertContainsAnyOf(AssertionInfo info, RangeSet<T> actual, T[] values) {
        this.assertNotNull(info, actual);
        this.failIfNull(values);
        if (actual.isEmpty() && values.length == 0) {
            return;
        }
        this.failIfEmpty(values);
        this.assertRangeSetContainsAnyGivenValues(info, (RangeSet)actual, (Comparable[])values);
    }

    public <T extends Comparable<T>> void assertContainsAnyRangesOf(AssertionInfo info, RangeSet<T> actual, Iterable<? extends T> values) {
        this.assertNotNull(info, actual);
        this.failIfNull(values);
        if (actual.isEmpty() && !values.iterator().hasNext()) {
            return;
        }
        this.failIfEmpty(values);
        this.assertRangeSetContainsAnyGivenValues(info, actual, (Comparable[])IterableUtil.toArray(values, Comparable.class));
    }

    private void assertRangeSetContainsAnyGivenValues(AssertionInfo info, RangeSet actual, Comparable[] values) {
        boolean match = Arrays.stream(values).anyMatch(arg_0 -> ((RangeSet)actual).contains(arg_0));
        if (!match) {
            throw this.failures.failure(info, ShouldContainAnyOf.shouldContainAnyOf((Object)actual, (Object)values));
        }
    }

    public <T extends Comparable<T>> void assertDoesNotContain(AssertionInfo info, RangeSet<T> actual, T[] values) {
        this.assertNotNull(info, actual);
        this.failIfNullOrEmpty(values);
        this.assertRangeSetDoesNotContainGivenValues(info, (RangeSet)actual, (Comparable[])values);
    }

    public <T extends Comparable<T>> void assertDoesNotContainAll(AssertionInfo info, RangeSet<T> actual, Iterable<? extends T> values) {
        this.assertNotNull(info, actual);
        this.failIfNullOrEmpty(values);
        this.assertRangeSetDoesNotContainGivenValues(info, actual, (Comparable[])IterableUtil.toArray(values, Comparable.class));
    }

    private void assertRangeSetDoesNotContainGivenValues(AssertionInfo info, RangeSet actual, Comparable[] values) {
        List elementsFound = Arrays.stream(values).filter(arg_0 -> ((RangeSet)actual).contains(arg_0)).collect(Collectors.toList());
        if (!elementsFound.isEmpty()) {
            throw this.failures.failure(info, ShouldNotContain.shouldNotContain((Object)actual, (Object)values, elementsFound));
        }
    }

    public <T extends Comparable<T>> void assertIntersects(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        this.assertNotNull(info, actual);
        this.failIfNull(ranges);
        if (actual.isEmpty() && ranges.length == 0) {
            return;
        }
        this.failIfEmpty(ranges);
        this.assertRangeSetIntersectsGivenValues(info, actual, ranges);
    }

    public <T extends Comparable<T>> void assertIntersectsAll(AssertionInfo info, RangeSet<T> actual, Iterable<? extends Range<T>> range) {
        this.assertNotNull(info, actual);
        this.failIfNull(range);
        if (actual.isEmpty() && !range.iterator().hasNext()) {
            return;
        }
        this.failIfEmpty(range);
        this.assertRangeSetIntersectsGivenValues(info, actual, (Range[])IterableUtil.toArray(range, Range.class));
    }

    public <T extends Comparable<T>> void assertIntersectsAll(AssertionInfo info, RangeSet<T> actual, RangeSet<T> rangeSet) {
        this.assertNotNull(info, actual);
        this.failIfNull(rangeSet);
        if (actual.isEmpty() && rangeSet.isEmpty()) {
            return;
        }
        this.failIfEmpty(rangeSet);
        this.assertRangeSetIntersectsGivenValues(info, actual, (Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private <T extends Comparable<T>> void assertRangeSetIntersectsGivenValues(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        List nonIntersectedRanges = Arrays.stream(ranges).filter(range -> !actual.intersects(range)).collect(Collectors.toList());
        if (!nonIntersectedRanges.isEmpty()) {
            throw this.failures.failure(info, RangeSetShouldIntersect.shouldIntersect(actual, ranges, nonIntersectedRanges));
        }
    }

    public <T extends Comparable<T>> void assertEmpty(AssertionInfo info, RangeSet<T> actual) {
        this.assertNotNull(info, actual);
        if (!actual.isEmpty()) {
            throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
        }
    }

    public <T extends Comparable<T>> void assertNotEmpty(AssertionInfo info, RangeSet<T> actual) {
        this.assertNotNull(info, actual);
        if (actual.isEmpty()) {
            throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public <T extends Comparable<T>> void assertNullOrEmpty(AssertionInfo info, RangeSet<T> actual) {
        if (actual != null && !actual.isEmpty()) {
            throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
        }
    }

    public <T extends Comparable<T>> void assertIntersectsAnyOf(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        this.assertNotNull(info, actual);
        this.failIfNull(ranges);
        if (actual.isEmpty() && ranges.length == 0) {
            return;
        }
        this.failIfEmpty(ranges);
        this.assertRangeSetIntersectsAnyOfGivenValues(info, actual, ranges);
    }

    public <T extends Comparable<T>> void assertIntersectsAnyRangesOf(AssertionInfo info, RangeSet<T> actual, Iterable<? extends Range<T>> range) {
        this.assertNotNull(info, actual);
        this.failIfNull(range);
        if (actual.isEmpty() && !range.iterator().hasNext()) {
            return;
        }
        this.failIfEmpty(range);
        this.assertRangeSetIntersectsAnyOfGivenValues(info, actual, (Range[])IterableUtil.toArray(range, Range.class));
    }

    public <T extends Comparable<T>> void assertIntersectsAnyRangesOf(AssertionInfo info, RangeSet<T> actual, RangeSet<T> rangeSet) {
        this.assertNotNull(info, actual);
        this.failIfNull(rangeSet);
        if (actual.isEmpty() && rangeSet.isEmpty()) {
            return;
        }
        this.failIfEmpty(rangeSet);
        this.assertRangeSetIntersectsAnyOfGivenValues(info, actual, (Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private <T extends Comparable<T>> void assertRangeSetIntersectsAnyOfGivenValues(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        boolean match = Arrays.stream(ranges).anyMatch(arg_0 -> actual.intersects(arg_0));
        if (!match) {
            throw this.failures.failure(info, RangeSetShouldIntersectAnyOf.shouldIntersectAnyOf(actual, ranges));
        }
    }

    public <T extends Comparable<T>> void assertDoesNotIntersect(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        this.assertNotNull(info, actual);
        this.failIfNullOrEmpty(ranges);
        this.assertRangeSetDoesNotIntersectGivenValues(info, actual, ranges);
    }

    public <T extends Comparable<T>> void assertDoesNotIntersectAnyRangeFrom(AssertionInfo info, RangeSet<T> actual, Iterable<? extends Range<T>> range) {
        this.assertNotNull(info, actual);
        this.failIfNullOrEmpty(range);
        this.assertRangeSetDoesNotIntersectGivenValues(info, actual, (Range[])IterableUtil.toArray(range, Range.class));
    }

    public <T extends Comparable<T>> void assertDoesNotIntersectAnyRangeFrom(AssertionInfo info, RangeSet<T> actual, RangeSet<T> rangeSet) {
        this.assertNotNull(info, actual);
        this.failIfNullOrEmpty(rangeSet);
        this.assertRangeSetDoesNotIntersectGivenValues(info, actual, (Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private <T extends Comparable<T>> void assertRangeSetDoesNotIntersectGivenValues(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        List intersected = Arrays.stream(ranges).filter(arg_0 -> actual.intersects(arg_0)).collect(Collectors.toList());
        if (!intersected.isEmpty()) {
            throw this.failures.failure(info, RangeSetShouldNotIntersect.shouldNotIntersects(actual, ranges, intersected));
        }
    }

    public <T extends Comparable<T>> void assertEncloses(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        this.assertNotNull(info, actual);
        this.failIfNull(ranges);
        if (actual.isEmpty() && ranges.length == 0) {
            return;
        }
        this.failIfEmpty(ranges);
        this.assertRangeSetEnclosesGivenValues(info, actual, ranges);
    }

    public <T extends Comparable<T>> void assertEnclosesAll(AssertionInfo info, RangeSet<T> actual, Iterable<? extends Range<T>> range) {
        this.assertNotNull(info, actual);
        this.failIfNull(range);
        if (actual.isEmpty() && !range.iterator().hasNext()) {
            return;
        }
        this.failIfEmpty(range);
        this.assertRangeSetEnclosesGivenValues(info, actual, (Range[])IterableUtil.toArray(range, Range.class));
    }

    public <T extends Comparable<T>> void assertEnclosesAll(AssertionInfo info, RangeSet<T> actual, RangeSet<T> rangeSet) {
        this.assertNotNull(info, actual);
        this.failIfNull(rangeSet);
        if (actual.isEmpty() && rangeSet.isEmpty()) {
            return;
        }
        this.failIfEmpty(rangeSet);
        this.assertRangeSetEnclosesGivenValues(info, actual, (Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private <T extends Comparable<T>> void assertRangeSetEnclosesGivenValues(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        List notEnclosed = Arrays.stream(ranges).filter(range -> !actual.encloses(range)).collect(Collectors.toList());
        if (!notEnclosed.isEmpty()) {
            throw this.failures.failure(info, RangeSetShouldEnclose.shouldEnclose(actual, ranges, notEnclosed));
        }
    }

    public <T extends Comparable<T>> void assertEnclosesAnyOf(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        this.assertNotNull(info, actual);
        this.failIfNull(ranges);
        if (actual.isEmpty() && ranges.length == 0) {
            return;
        }
        this.failIfEmpty(ranges);
        this.assertRangeSetEnclosesAnyOfGivenValues(info, actual, ranges);
    }

    public <T extends Comparable<T>> void assertEnclosesAnyRangesOf(AssertionInfo info, RangeSet<T> actual, Iterable<? extends Range<T>> range) {
        this.assertNotNull(info, actual);
        this.failIfNull(range);
        if (actual.isEmpty() && !range.iterator().hasNext()) {
            return;
        }
        this.failIfEmpty(range);
        this.assertRangeSetEnclosesAnyOfGivenValues(info, actual, (Range[])IterableUtil.toArray(range, Range.class));
    }

    public <T extends Comparable<T>> void assertEnclosesAnyRangesOf(AssertionInfo info, RangeSet<T> actual, RangeSet<T> rangeSet) {
        this.assertNotNull(info, actual);
        this.failIfNull(rangeSet);
        if (actual.isEmpty() && rangeSet.isEmpty()) {
            return;
        }
        this.failIfEmpty(rangeSet);
        this.assertRangeSetEnclosesAnyOfGivenValues(info, actual, (Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private <T extends Comparable<T>> void assertRangeSetEnclosesAnyOfGivenValues(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        boolean match = Arrays.stream(ranges).anyMatch(arg_0 -> actual.encloses(arg_0));
        if (!match) {
            throw this.failures.failure(info, RangeSetShouldEncloseAnyOf.shouldEncloseAnyOf(actual, ranges));
        }
    }

    public <T extends Comparable<T>> void assertDoesNotEnclose(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        this.assertNotNull(info, actual);
        this.failIfNullOrEmpty(ranges);
        this.assertRangeSetDoesNotEncloseGivenValues(info, actual, ranges);
    }

    public <T extends Comparable<T>> void doesNotEncloseAnyRangesOf(AssertionInfo info, RangeSet<T> actual, Iterable<? extends Range<T>> range) {
        this.assertNotNull(info, actual);
        this.failIfNullOrEmpty(range);
        this.assertRangeSetDoesNotEncloseGivenValues(info, actual, (Range[])IterableUtil.toArray(range, Range.class));
    }

    public <T extends Comparable<T>> void doesNotEncloseAnyRangesOf(AssertionInfo info, RangeSet<T> actual, RangeSet<T> rangeSet) {
        this.assertNotNull(info, actual);
        this.failIfNullOrEmpty(rangeSet);
        this.assertRangeSetDoesNotEncloseGivenValues(info, actual, (Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private <T extends Comparable<T>> void assertRangeSetDoesNotEncloseGivenValues(AssertionInfo info, RangeSet<T> actual, Range<T>[] ranges) {
        List enclosedRanges = Arrays.stream(ranges).filter(arg_0 -> actual.encloses(arg_0)).collect(Collectors.toList());
        if (!enclosedRanges.isEmpty()) {
            throw this.failures.failure(info, RangeSetShouldNotEnclose.shouldNotEnclose(actual, ranges, enclosedRanges));
        }
    }

    private void assertNotNull(AssertionInfo info, RangeSet<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private void failIfNull(Object[] array) {
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(array == null, org.assertj.core.internal.ErrorMessages.valuesToLookForIsNull(), new Object[0]);
    }

    private void failIfNull(Iterable<?> iterable) {
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(iterable == null, org.assertj.core.internal.ErrorMessages.iterableValuesToLookForIsNull(), new Object[0]);
    }

    private void failIfNull(RangeSet<?> rangeSet) {
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(rangeSet == null, ErrorMessages.rangeSetValuesToLookForIsNull(), new Object[0]);
    }

    private void failIfEmpty(Object[] values) {
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values.length == 0, org.assertj.core.internal.ErrorMessages.valuesToLookForIsEmpty(), new Object[0]);
    }

    private void failIfEmpty(Iterable<?> values) {
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(!values.iterator().hasNext(), org.assertj.core.internal.ErrorMessages.iterableValuesToLookForIsEmpty(), new Object[0]);
    }

    private void failIfEmpty(RangeSet<?> rangeSet) {
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(rangeSet.isEmpty(), ErrorMessages.rangeSetValuesToLookForIsEmpty(), new Object[0]);
    }

    private void failIfNullOrEmpty(Object[] values) {
        this.failIfNull(values);
        this.failIfEmpty(values);
    }

    private void failIfNullOrEmpty(Iterable<?> values) {
        this.failIfNull(values);
        this.failIfEmpty(values);
    }

    private void failIfNullOrEmpty(RangeSet<?> rangeSet) {
        this.failIfNull(rangeSet);
        this.failIfEmpty(rangeSet);
    }
}

