/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.base.Optional;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.guava.error.OptionalShouldBeAbsent;
import org.assertj.guava.error.OptionalShouldBePresent;
import org.assertj.guava.error.OptionalShouldBePresentWithValue;

public class OptionalAssert<T>
extends AbstractAssert<OptionalAssert<T>, Optional<T>> {
    protected OptionalAssert(Optional<T> actual) {
        super(actual, OptionalAssert.class);
    }

    protected Optional<T> getActual() {
        return (Optional)this.actual;
    }

    public OptionalAssert<T> contains(Object value) {
        this.isNotNull();
        if (!((Optional)this.actual).isPresent()) {
            throw this.assertionError(OptionalShouldBePresentWithValue.shouldBePresentWithValue(value));
        }
        if (!this.areEqual(((Optional)this.actual).get(), value)) {
            throw this.assertionError(OptionalShouldBePresentWithValue.shouldBePresentWithValue((Optional)this.actual, value));
        }
        return this;
    }

    public OptionalAssert<T> isAbsent() {
        this.isNotNull();
        if (((Optional)this.actual).isPresent()) {
            throw this.assertionError(OptionalShouldBeAbsent.shouldBeAbsent((Optional)this.actual));
        }
        return this;
    }

    public OptionalAssert<T> isPresent() {
        this.isNotNull();
        if (!((Optional)this.actual).isPresent()) {
            throw this.assertionError(OptionalShouldBePresent.shouldBePresent((Optional)this.actual));
        }
        return this;
    }

    public AbstractObjectAssert<?, T> extractingValue() {
        this.isPresent();
        Object assertion = ((Optional)this.actual).get();
        return Assertions.assertThat((Object)assertion);
    }

    public AbstractCharSequenceAssert<?, ? extends CharSequence> extractingCharSequence() {
        this.isPresent();
        Assertions.assertThat((Object)((Optional)this.actual).get()).isInstanceOf(CharSequence.class);
        return Assertions.assertThat((CharSequence)((CharSequence)((Optional)this.actual).get()));
    }
}

