/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.base.Optional;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.guava.error.OptionalShouldBeAbsent;
import org.assertj.guava.error.OptionalShouldBePresent;
import org.assertj.guava.error.OptionalShouldBePresentWithValue;

public class OptionalAssert<T>
extends AbstractAssert<OptionalAssert<T>, Optional<T>> {
    @VisibleForTesting
    Failures failures = Failures.instance();

    protected OptionalAssert(Optional<T> actual) {
        super(actual, OptionalAssert.class);
    }

    protected Optional<T> getActual() {
        return (Optional)this.actual;
    }

    public OptionalAssert<T> contains(Object value) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Optional)this.actual).isPresent()) {
            throw this.failures.failure((AssertionInfo)this.info, OptionalShouldBePresentWithValue.shouldBePresentWithValue(value));
        }
        if (!((Optional)this.actual).get().equals(value)) {
            throw this.failures.failure((AssertionInfo)this.info, OptionalShouldBePresentWithValue.shouldBePresentWithValue((Optional)this.actual, value));
        }
        return this;
    }

    public OptionalAssert<T> isAbsent() {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (((Optional)this.actual).isPresent()) {
            throw this.failures.failure((AssertionInfo)this.info, OptionalShouldBeAbsent.shouldBeAbsent((Optional)this.actual));
        }
        return this;
    }

    public OptionalAssert<T> isPresent() {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Optional)this.actual).isPresent()) {
            throw this.failures.failure((AssertionInfo)this.info, OptionalShouldBePresent.shouldBePresent((Optional)this.actual));
        }
        return this;
    }
}

