/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.field;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.core.nd.IDestructable;
import org.aspectj.org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.Field;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldChar;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldDouble;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldFloat;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldInt;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldLong;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldPointer;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldShort;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IRefCountedField;

public final class StructDef<T> {
    Class<T> clazz;
    private StructDef<? super T> superClass;
    private List<IField> fields = new ArrayList<IField>();
    private boolean doneCalled;
    private boolean offsetsComputed;
    private List<StructDef<? extends T>> subClasses = new ArrayList<StructDef<? extends T>>();
    private int size;
    List<IDestructableField> destructableFields = new ArrayList<IDestructableField>();
    boolean refCounted;
    private List<IRefCountedField> refCountedFields = new ArrayList<IRefCountedField>();
    private List<IRefCountedField> ownerFields = new ArrayList<IRefCountedField>();
    boolean isAbstract;
    private ITypeFactory<T> factory;
    protected boolean hasUserDestructor;
    private DeletionSemantics deletionSemantics;

    private StructDef(Class<T> clazz) {
        this(clazz, null);
    }

    private StructDef(Class<T> clazz, StructDef<? super T> superClass) {
        this(clazz, superClass, Modifier.isAbstract(clazz.getModifiers()));
    }

    private StructDef(Class<T> clazz, StructDef<? super T> superClass, boolean isAbstract) {
        Constructor<T> constructor;
        this.clazz = clazz;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClass.subClasses.add(this);
        }
        this.isAbstract = isAbstract;
        final String fullyQualifiedClassName = clazz.getName();
        if (!this.isAbstract) {
            try {
                constructor = clazz.getConstructor(Nd.class, Long.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException("The node class " + fullyQualifiedClassName + " does not have an appropriate constructor for it to be used with Nd");
            }
        } else {
            constructor = null;
        }
        this.hasUserDestructor = IDestructable.class.isAssignableFrom(clazz);
        this.factory = new ITypeFactory<T>(){

            @Override
            public T create(Nd dom, long address) {
                if (StructDef.this.isAbstract) {
                    throw new UnsupportedOperationException("Attempting to instantiate abstract class" + fullyQualifiedClassName);
                }
                try {
                    return constructor.newInstance(dom, address);
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getCause();
                    if (target instanceof RuntimeException) {
                        throw (RuntimeException)target;
                    }
                    throw new RuntimeException("Error in AutoTypeFactory", e);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Error in AutoTypeFactory", e);
                }
            }

            @Override
            public int getRecordSize() {
                return StructDef.this.size();
            }

            @Override
            public boolean hasDestructor() {
                return StructDef.this.hasUserDestructor || StructDef.this.hasDestructableFields();
            }

            @Override
            public Class<?> getElementClass() {
                return StructDef.this.clazz;
            }

            @Override
            public void destruct(Nd nd, long address) {
                StructDef.this.checkNotMutable();
                if (StructDef.this.hasUserDestructor) {
                    IDestructable destructable = (IDestructable)this.create(nd, address);
                    destructable.destruct();
                }
                this.destructFields(nd, address);
            }

            @Override
            public void destructFields(Nd dom, long address) {
                StructDef.this.destructFields(dom, address);
            }

            @Override
            public boolean isReadyForDeletion(Nd dom, long address) {
                return StructDef.this.isReadyForDeletion(dom, address);
            }

            @Override
            public DeletionSemantics getDeletionSemantics() {
                return StructDef.this.getDeletionSemantics();
            }
        };
    }

    public Class<T> getStructClass() {
        return this.clazz;
    }

    public String toString() {
        return this.clazz.getName();
    }

    public static <T> StructDef<T> createAbstract(Class<T> clazz) {
        return new StructDef<T>(clazz, null, true);
    }

    public static <T> StructDef<T> createAbstract(Class<T> clazz, StructDef<? super T> superClass) {
        return new StructDef<T>(clazz, superClass, true);
    }

    public static <T> StructDef<T> create(Class<T> clazz) {
        return new StructDef<T>(clazz);
    }

    public static <T> StructDef<T> create(Class<T> clazz, StructDef<? super T> superClass) {
        return new StructDef<T>(clazz, superClass);
    }

    protected boolean isReadyForDeletion(Nd dom, long address) {
        List<IRefCountedField> toIterate = Collections.EMPTY_LIST;
        switch (this.deletionSemantics) {
            case EXPLICIT: {
                return false;
            }
            case OWNED: {
                toIterate = this.ownerFields;
                break;
            }
            case REFCOUNTED: {
                toIterate = this.refCountedFields;
            }
        }
        for (IRefCountedField next : toIterate) {
            if (!next.hasReferences(dom, address)) continue;
            return false;
        }
        StructDef<T> localSuperClass = this.superClass;
        if (localSuperClass != null && localSuperClass.deletionSemantics != DeletionSemantics.EXPLICIT) {
            return localSuperClass.isReadyForDeletion(dom, address);
        }
        return true;
    }

    protected boolean hasDestructableFields() {
        return !this.destructableFields.isEmpty() || this.superClass != null && this.superClass.hasDestructableFields();
    }

    public DeletionSemantics getDeletionSemantics() {
        return this.deletionSemantics;
    }

    public void done() {
        if (this.doneCalled) {
            throw new IllegalStateException("May not call done() more than once");
        }
        this.doneCalled = true;
        if (this.superClass == null || this.superClass.areOffsetsComputed()) {
            this.computeOffsets();
        }
    }

    public void add(IField toAdd) {
        this.checkMutable();
        this.fields.add(toAdd);
    }

    public void addDestructableField(IDestructableField field) {
        this.checkMutable();
        this.destructableFields.add(field);
    }

    public StructDef<T> useStandardRefCounting() {
        this.checkMutable();
        this.refCounted = true;
        return this;
    }

    public void addRefCountedField(IRefCountedField result) {
        this.checkMutable();
        this.refCountedFields.add(result);
    }

    public void addOwnerField(IRefCountedField result) {
        this.checkMutable();
        this.ownerFields.add(result);
    }

    public boolean areOffsetsComputed() {
        return this.offsetsComputed;
    }

    public int size() {
        this.checkNotMutable();
        return this.size;
    }

    void checkNotMutable() {
        if (!this.offsetsComputed) {
            throw new IllegalStateException("Must call done() before using the struct");
        }
    }

    private void checkMutable() {
        if (this.doneCalled) {
            throw new IllegalStateException("May not modify a StructDef after done() has been called");
        }
    }

    private void computeOffsets() {
        int offset = this.superClass == null ? 0 : this.superClass.size();
        for (IField iField : this.fields) {
            iField.setOffset(offset);
            offset += iField.getRecordSize();
        }
        this.size = offset;
        this.deletionSemantics = this.refCounted ? DeletionSemantics.REFCOUNTED : (!this.ownerFields.isEmpty() ? DeletionSemantics.OWNED : (this.superClass != null ? this.superClass.deletionSemantics : DeletionSemantics.EXPLICIT));
        if (this.superClass != null && this.deletionSemantics != this.superClass.deletionSemantics && this.superClass.deletionSemantics != DeletionSemantics.EXPLICIT) {
            throw new IllegalStateException("A class (" + this.clazz.getName() + ") that uses " + this.deletionSemantics.toString() + " deletion semantics may not inherit from a class " + "that uses " + this.superClass.deletionSemantics.toString() + " semantics");
        }
        this.offsetsComputed = true;
        for (StructDef structDef : this.subClasses) {
            if (!structDef.doneCalled) continue;
            structDef.computeOffsets();
        }
    }

    public FieldPointer addPointer() {
        FieldPointer result = new FieldPointer();
        this.add(result);
        return result;
    }

    public FieldShort addShort() {
        FieldShort result = new FieldShort();
        this.add(result);
        return result;
    }

    public FieldInt addInt() {
        FieldInt result = new FieldInt();
        this.add(result);
        return result;
    }

    public FieldLong addLong() {
        FieldLong result = new FieldLong();
        this.add(result);
        return result;
    }

    public FieldString addString() {
        FieldString result = new FieldString();
        this.add(result);
        this.addDestructableField(result);
        return result;
    }

    public FieldDouble addDouble() {
        FieldDouble result = new FieldDouble();
        this.add(result);
        return result;
    }

    public FieldFloat addFloat() {
        FieldFloat result = new FieldFloat();
        this.add(result);
        return result;
    }

    public FieldByte addByte() {
        FieldByte result = new FieldByte();
        this.add(result);
        return result;
    }

    public FieldChar addChar() {
        FieldChar result = new FieldChar();
        this.add(result);
        return result;
    }

    public <F> Field<F> add(ITypeFactory<F> factory1) {
        Field<F> result = new Field<F>(factory1);
        this.add(result);
        if (result.factory.hasDestructor()) {
            this.destructableFields.add(result);
        }
        return result;
    }

    public ITypeFactory<T> getFactory() {
        return this.factory;
    }

    void destructFields(Nd dom, long address) {
        for (IDestructableField next : this.destructableFields) {
            next.destruct(dom, address);
        }
        if (this.superClass != null) {
            this.superClass.destructFields(dom, address);
        }
    }

    public static enum DeletionSemantics {
        EXPLICIT,
        OWNED,
        REFCOUNTED;

    }
}

