/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.extension;

import java.io.InputStream;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyExtensionRegistry {
    private Ruby rubyRuntime;

    public RubyExtensionRegistry(Ruby rubyRuntime) {
        this.rubyRuntime = rubyRuntime;
    }

    public RubyExtensionRegistry requireLibrary(String requiredLibrary) {
        RubyUtils.requireLibrary(this.rubyRuntime, requiredLibrary);
        return this;
    }

    public RubyExtensionRegistry loadClass(InputStream rubyClassStream) {
        RubyUtils.loadRubyClass(this.rubyRuntime, rubyClassStream);
        return this;
    }

    public RubyExtensionRegistry preprocessor(String preprocessor) {
        this.getAsciidoctorModule().callMethod("preprocessor", (IRubyObject)this.rubyRuntime.newString(preprocessor));
        return this;
    }

    public RubyExtensionRegistry postprocessor(String postprocessor) {
        this.getAsciidoctorModule().callMethod("postprocessor", (IRubyObject)this.rubyRuntime.newString(postprocessor));
        return this;
    }

    public RubyExtensionRegistry docinfoProcessor(String docinfoProcessor) {
        this.getAsciidoctorModule().callMethod("docinfo_processor", (IRubyObject)this.rubyRuntime.newString(docinfoProcessor));
        return this;
    }

    public RubyExtensionRegistry includeProcessor(String includeProcessor) {
        this.getAsciidoctorModule().callMethod("include_processor", (IRubyObject)this.rubyRuntime.newString(includeProcessor));
        return this;
    }

    public RubyExtensionRegistry treeprocessor(String treeProcessor) {
        this.getAsciidoctorModule().callMethod("treeprocessor", (IRubyObject)this.rubyRuntime.newString(treeProcessor));
        return this;
    }

    public RubyExtensionRegistry block(String blockName, String blockProcessor) {
        this.getAsciidoctorModule().callMethod("block_processor", new IRubyObject[]{this.rubyRuntime.newString(blockProcessor), RubyUtils.toSymbol(this.rubyRuntime, blockName)});
        return this;
    }

    public RubyExtensionRegistry block(String blockProcessor) {
        this.getAsciidoctorModule().callMethod("block_processor", (IRubyObject)this.rubyRuntime.newString(blockProcessor));
        return this;
    }

    public RubyExtensionRegistry blockMacro(String blockName, String blockMacroProcessor) {
        this.getAsciidoctorModule().callMethod("block_macro", new IRubyObject[]{this.rubyRuntime.newString(blockMacroProcessor), RubyUtils.toSymbol(this.rubyRuntime, blockName)});
        return this;
    }

    public RubyExtensionRegistry blockMacro(String blockMacroProcessor) {
        this.getAsciidoctorModule().callMethod("block_macro", (IRubyObject)this.rubyRuntime.newString(blockMacroProcessor));
        return this;
    }

    public RubyExtensionRegistry inlineMacro(String blockName, String inlineMacroProcessor) {
        this.getAsciidoctorModule().callMethod("inline_macro", new IRubyObject[]{this.rubyRuntime.newString(inlineMacroProcessor), RubyUtils.toSymbol(this.rubyRuntime, blockName)});
        return this;
    }

    public RubyExtensionRegistry inlineMacro(String inlineMacroProcessor) {
        this.getAsciidoctorModule().callMethod("inline_macro", (IRubyObject)this.rubyRuntime.newString(inlineMacroProcessor));
        return this;
    }

    private RubyModule getAsciidoctorModule() {
        return this.rubyRuntime.getModule("AsciidoctorModule");
    }
}

