/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.converter;

import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.converter.Converter;
import org.asciidoctor.converter.ConverterFor;
import org.asciidoctor.converter.ConverterProxy;
import org.asciidoctor.converter.OutputFormatWriter;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaConverterRegistry {
    private Ruby rubyRuntime;

    public JavaConverterRegistry(Ruby rubyRuntime) {
        this.rubyRuntime = rubyRuntime;
    }

    public <U, T extends Converter<U> & OutputFormatWriter<U>> void register(Class<T> converterClass, String ... backends) {
        RubyClass clazz = ConverterProxy.register(this.rubyRuntime, converterClass);
        ConverterFor converterForAnnotation = converterClass.getAnnotation(ConverterFor.class);
        if (converterForAnnotation != null) {
            String backend = !"".equals(converterForAnnotation.format()) ? converterForAnnotation.format() : converterForAnnotation.value();
            this.getConverterFactory().callMethod("register", new IRubyObject[]{clazz, this.rubyRuntime.newArray((IRubyObject)this.rubyRuntime.newString(backend))});
        } else if (backends.length == 0) {
            this.getConverterFactory().callMethod("register", (IRubyObject)clazz);
        }
        if (backends.length > 0) {
            RubyArray rubyBackendNames = new RubyArray(this.rubyRuntime, backends.length);
            for (String backend : backends) {
                rubyBackendNames.add((Object)this.rubyRuntime.newString(backend));
            }
            this.getConverterFactory().callMethod("register", new IRubyObject[]{clazz, rubyBackendNames});
        }
    }

    public Class<?> resolve(String backend) {
        RubyClass rubyClass = (RubyClass)this.getConverterFactory().callMethod("resolve", (IRubyObject)this.rubyRuntime.newString(backend));
        Class clazz = rubyClass.getReifiedClass();
        if (clazz != null) {
            return clazz;
        }
        if (rubyClass.getAllocator() instanceof ConverterProxy.Allocator) {
            ConverterProxy.Allocator allocator = (ConverterProxy.Allocator)rubyClass.getAllocator();
            return allocator.getConverterClass();
        }
        return null;
    }

    public void unregisterAll() {
        this.getConverterFactory().callMethod("unregister_all");
    }

    private RubyClass getConverterFactory() {
        return this.rubyRuntime.getModule("Asciidoctor").defineOrGetModuleUnder("Converter").getClass("Factory");
    }

    public Map<String, Class<?>> converters() {
        RubyArray rubyKeys = (RubyArray)this.getConverterFactory().callMethod("converters").callMethod(this.rubyRuntime.getCurrentContext(), "keys");
        HashMap converters = new HashMap();
        for (Object rubyBackend : rubyKeys) {
            String backend = rubyBackend.toString();
            converters.put(backend, this.resolve(backend));
        }
        return converters;
    }
}

