/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.maven.log.LogHandler;
import org.asciidoctor.maven.log.LogRecordFormatter;
import org.asciidoctor.maven.log.LogRecordsProcessors;
import org.asciidoctor.maven.log.MemoryLogHandler;
import org.asciidoctor.maven.site.HeadParser;
import org.asciidoctor.maven.site.SiteConversionConfiguration;
import org.asciidoctor.maven.site.SiteConversionConfigurationParser;
import org.asciidoctor.maven.site.SiteConverterDecorator;
import org.asciidoctor.maven.site.SiteLogHandlerDeserializer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=Parser.class, hint="asciidoc")
public class AsciidoctorDoxiaParser
extends AbstractTextParser {
    @Inject
    protected Provider<MavenProject> mavenProjectProvider;
    public static final String ROLE_HINT = "asciidoc";

    public void parse(Reader reader, Sink sink, String reference) throws ParseException {
        String source;
        try {
            source = IOUtil.toString((Reader)reader);
            if (source == null) {
                source = "";
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("Could not read AsciiDoc source: " + ex.getLocalizedMessage()));
            return;
        }
        MavenProject project = (MavenProject)this.mavenProjectProvider.get();
        Xpp3Dom siteConfig = this.getSiteConfig(project);
        File siteDirectory = this.resolveSiteDirectory(project, siteConfig);
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        SiteConversionConfiguration conversionConfig = new SiteConversionConfigurationParser(project).processAsciiDocConfig(siteConfig, this.defaultOptions(siteDirectory), this.defaultAttributes());
        for (String require : conversionConfig.getRequires()) {
            this.requireLibrary(asciidoctor, require);
        }
        LogHandler logHandler = this.getLogHandlerConfig(siteConfig);
        MemoryLogHandler memoryLogHandler = this.asciidoctorLoggingSetup(asciidoctor, logHandler, siteDirectory);
        SiteConverterDecorator siteConverter = new SiteConverterDecorator(asciidoctor);
        SiteConverterDecorator.Result headerMetadata = siteConverter.process(source, conversionConfig.getOptions());
        try {
            new LogRecordsProcessors(logHandler, siteDirectory, errorMessage -> this.getLog().error((CharSequence)errorMessage)).processLogRecords(memoryLogHandler);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), exception);
        }
        new HeadParser(sink).parse(headerMetadata.getHeaderMetadata());
        sink.rawText(headerMetadata.getHtml());
    }

    private MemoryLogHandler asciidoctorLoggingSetup(Asciidoctor asciidoctor, LogHandler logHandler, File siteDirectory) {
        MemoryLogHandler memoryLogHandler = new MemoryLogHandler(logHandler.getOutputToConsole(), siteDirectory, logRecord -> this.getLog().info((CharSequence)LogRecordFormatter.format(logRecord, siteDirectory)));
        asciidoctor.registerLogHandler((org.asciidoctor.log.LogHandler)memoryLogHandler);
        Logger.getLogger("asciidoctor").setUseParentHandlers(false);
        return memoryLogHandler;
    }

    private LogHandler getLogHandlerConfig(Xpp3Dom siteConfig) {
        Xpp3Dom asciidoc = siteConfig == null ? null : siteConfig.getChild(ROLE_HINT);
        return new SiteLogHandlerDeserializer().deserialize(asciidoc);
    }

    protected Xpp3Dom getSiteConfig(MavenProject project) {
        return project.getGoalConfiguration("org.apache.maven.plugins", "maven-site-plugin", "site", "site");
    }

    protected File resolveSiteDirectory(MavenProject project, Xpp3Dom siteConfig) {
        Xpp3Dom siteDirectoryNode;
        File siteDirectory = new File(project.getBasedir(), "src/site");
        if (siteConfig != null && (siteDirectoryNode = siteConfig.getChild("siteDirectory")) != null) {
            siteDirectory = new File(siteDirectoryNode.getValue());
        }
        return siteDirectory;
    }

    protected OptionsBuilder defaultOptions(File siteDirectory) {
        return OptionsBuilder.options().backend("xhtml").safe(SafeMode.UNSAFE).baseDir(new File(siteDirectory, ROLE_HINT));
    }

    protected AttributesBuilder defaultAttributes() {
        return AttributesBuilder.attributes().attribute("idprefix", (Object)"@").attribute("showtitle", (Object)"@");
    }

    private void requireLibrary(Asciidoctor asciidoctor, String require) {
        if (!(require = require.trim()).isEmpty()) {
            try {
                asciidoctor.requireLibrary(new String[]{require});
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)ex.getLocalizedMessage());
            }
        }
    }
}

