/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.asciidoctor.maven.log.LogHandler;
import org.asciidoctor.maven.log.LogRecordFormatter;
import org.asciidoctor.maven.log.MemoryLogHandler;

public class LogRecordsProcessors {
    private final LogHandler logHandler;
    private final File sourceDirectory;
    private final Consumer<String> errorMessageConsumer;

    public LogRecordsProcessors(LogHandler logHandler, File sourceDirectory, Consumer<String> errorMessageConsumer) {
        this.logHandler = logHandler;
        this.sourceDirectory = sourceDirectory;
        this.errorMessageConsumer = errorMessageConsumer;
    }

    public void processLogRecords(MemoryLogHandler memoryLogHandler) throws Exception {
        String textToSearch;
        List<LogRecord> records;
        if (this.logHandler.isSeveritySet() && this.logHandler.isContainsTextNotBlank()) {
            String textToSearch2;
            Severity severity = this.logHandler.getFailIf().getSeverity();
            List<LogRecord> records2 = memoryLogHandler.filter(severity, textToSearch2 = this.logHandler.getFailIf().getContainsText());
            if (records2.size() > 0) {
                for (LogRecord record : records2) {
                    this.errorMessageConsumer.accept(LogRecordFormatter.format(record, this.sourceDirectory));
                }
                throw new Exception(String.format("Found %s issue(s) matching severity %s or higher and text '%s'", records2.size(), severity, textToSearch2));
            }
        } else if (this.logHandler.isSeveritySet()) {
            Severity severity = this.logHandler.getFailIf().getSeverity();
            List<LogRecord> records3 = memoryLogHandler.filter(severity);
            if (records3.size() > 0) {
                for (LogRecord record : records3) {
                    this.errorMessageConsumer.accept(LogRecordFormatter.format(record, this.sourceDirectory));
                }
                throw new Exception(String.format("Found %s issue(s) of severity %s or higher during conversion", records3.size(), severity));
            }
        } else if (this.logHandler.isContainsTextNotBlank() && (records = memoryLogHandler.filter(textToSearch = this.logHandler.getFailIf().getContainsText())).size() > 0) {
            for (LogRecord record : records) {
                this.errorMessageConsumer.accept(LogRecordFormatter.format(record, this.sourceDirectory));
            }
            throw new Exception(String.format("Found %s issue(s) containing '%s'", records.size(), textToSearch));
        }
    }
}

