/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.logging.Log;
import org.asciidoctor.maven.http.AsciidoctorHandler;

public class AsciidoctorHttpServer {
    private static final String HOST = "localhost";
    private static final int THREAD_NUMBER = 3;
    private static final String THREAD_PREFIX = "asciidoctor-thread-";
    private final Log logger;
    private final int port;
    private final File workDir;
    private final String defaultPage;
    private ServerBootstrap bootstrap;
    private NioEventLoopGroup workerGroup;

    public AsciidoctorHttpServer(Log logger, int port, File outputDirectory, String defaultPage) {
        this.logger = logger;
        this.port = port;
        this.workDir = outputDirectory;
        this.defaultPage = defaultPage;
    }

    public AsciidoctorHttpServer start() {
        AtomicInteger threadId = new AtomicInteger(1);
        this.workerGroup = new NioEventLoopGroup(3, runnable -> {
            Thread t = new Thread(runnable, THREAD_PREFIX + threadId.getAndIncrement());
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            return t;
        });
        try {
            this.bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)1024)).option(ChannelOption.TCP_NODELAY, (Object)true)).group((EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast("decoder", (ChannelHandler)new HttpRequestDecoder()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE)).addLast("encoder", (ChannelHandler)new HttpResponseEncoder()).addLast("chunked-writer", (ChannelHandler)new ChunkedWriteHandler()).addLast("asciidoctor", (ChannelHandler)new AsciidoctorHandler(AsciidoctorHttpServer.this.workDir, AsciidoctorHttpServer.this.defaultPage));
                }
            }).bind(this.port).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    this.logger.error((CharSequence)"Can't start HTTP server");
                } else {
                    this.logger.info((CharSequence)String.format("Server started on http://%s:%s", HOST, this.port));
                }
            })).sync();
        }
        catch (InterruptedException e) {
            this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public void stop() {
        Future shutdownGracefully = this.workerGroup.shutdownGracefully();
        this.logger.info((CharSequence)"Server stopping...");
        try {
            shutdownGracefully.get();
            this.logger.info((CharSequence)"Server stopped");
        }
        catch (InterruptedException e) {
            this.logger.error((Throwable)e);
        }
        catch (ExecutionException e) {
            this.logger.error((Throwable)e);
        }
    }
}

