/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Cursor;
import org.asciidoctor.log.LogRecord;

public class LogRecordFormatter {
    private static final String MESSAGE_HEADER = "asciidoctor";

    public static String format(LogRecord logRecord, File sourceDirectory) {
        Cursor cursor = logRecord.getCursor();
        String sourcePath = LogRecordFormatter.calculateFileRelativePath(cursor, sourceDirectory);
        if (sourcePath == null && cursor != null) {
            sourcePath = cursor.getFile();
        }
        ArrayList<String> messageParts = new ArrayList<String>();
        messageParts.add(MESSAGE_HEADER);
        messageParts.add(logRecord.getSeverity().toString());
        if (sourcePath != null) {
            messageParts.add(sourcePath);
        }
        if (cursor != null && cursor.getLineNumber() > 0) {
            messageParts.add("line " + cursor.getLineNumber());
        }
        messageParts.add(logRecord.getMessage());
        return messageParts.stream().collect(Collectors.joining(": "));
    }

    private static String calculateFileRelativePath(Cursor cursor, File sourceDirectory) {
        try {
            String sourceDir;
            String sourceFile;
            if (LogRecordFormatter.isValidFile(cursor) && (sourceFile = new File(cursor.getFile()).getCanonicalPath()).startsWith(sourceDir = sourceDirectory.getCanonicalPath())) {
                return sourceFile.substring(sourceDirectory.getCanonicalPath().length() + 1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static boolean isValidFile(Cursor cursor) {
        return cursor != null && cursor.getFile() != null && !LogRecordFormatter.isHttpSource(cursor.getFile());
    }

    private static boolean isHttpSource(String filePath) {
        return filePath.startsWith("http://") || filePath.startsWith("https://");
    }
}

