/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

public class AsciidoctorFileScanner {
    public static final String ASCIIDOC_FILE_EXTENSIONS_REG_EXP = "a((sc(iidoc)?)|d(oc)?)";
    public static final String ASCIIDOC_NON_INTERNAL_REG_EXP = "^[^_.].*\\.a((sc(iidoc)?)|d(oc)?)$";
    public static String[] DEFAULT_ASCIIDOC_EXTENSIONS = new String[]{"**/*.adoc", "**/*.ad", "**/*.asc", "**/*.asciidoc"};
    public static String[] INTERNAL_FOLDERS_AND_FILES_PATTERNS = new String[]{"**/_*.*", "**/_*", "**/_*/**/*.*"};
    public static String[] IGNORED_FILE_NAMES = new String[]{"docinfo.html", "docinfo-header.html", "docinfo-footer.html", "*-docinfo.html", "*-docinfo-header.html", "*-docinfo-footer.html", "docinfo.xml", "docinfo-header.xml", "docinfo-footer.xml", "*-docinfo.xml", "*-docinfo-header.xml", "*-docinfo-footer.xml"};
    private final BuildContext buildContext;

    public AsciidoctorFileScanner(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public List<File> scan(Resource resource) {
        Scanner scanner = this.buildContext.newScanner(new File(resource.getDirectory()), true);
        this.setupScanner(scanner, resource);
        scanner.scan();
        ArrayList<File> files = new ArrayList<File>();
        for (String file : scanner.getIncludedFiles()) {
            files.add(new File(resource.getDirectory(), file));
        }
        return files;
    }

    public List<File> scan(List<Resource> resources) {
        ArrayList<File> files = new ArrayList<File>();
        for (Resource resource : resources) {
            files.addAll(this.scan(resource));
        }
        return files;
    }

    private void setupScanner(Scanner scanner, Resource resource) {
        if (this.isEmpty(resource.getIncludes())) {
            scanner.setIncludes(DEFAULT_ASCIIDOC_EXTENSIONS);
        } else {
            scanner.setIncludes(resource.getIncludes().toArray(new String[0]));
        }
        if (this.isEmpty(resource.getExcludes())) {
            scanner.setExcludes(IGNORED_FILE_NAMES);
        } else {
            scanner.setExcludes(this.mergeAndConvert(resource.getExcludes(), IGNORED_FILE_NAMES));
        }
        scanner.addDefaultExcludes();
    }

    private boolean isEmpty(List<String> excludes) {
        return excludes == null || excludes.isEmpty();
    }

    private String[] mergeAndConvert(List<String> list, String[] array) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(array));
        set.addAll(list);
        return set.toArray(new String[set.size()]);
    }
}

