/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.endtoend.gettingthingsdone;

import java.io.InputStream;
import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.common.ArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;

public class GettingThingsDoneDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/artificer-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "artificer1!";
    private static final String GTD_LIST_ITEM = "GTDListItem";
    private static final String GTD_PROJECT = "GTDProject";
    private static final String GTD_PROJECT_RELATIONSHIP = "GTDProjectRel";

    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running Demo ***\n");
        String endpoint = System.getProperty("artificer.endpoint");
        String username = System.getProperty("artificer.auth.username");
        String password = System.getProperty("artificer.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("Artificer Endpoint: " + endpoint);
        System.out.println("Artificer User: " + username);
        ArtificerAtomApiClient client = new ArtificerAtomApiClient(endpoint, username, password, true);
        System.out.println("\nUploading the ontology (gettingthingsdone.owl.xml)...");
        InputStream is = GettingThingsDoneDemo.class.getResourceAsStream("/gettingthingsdone.owl.xml");
        client.uploadOntology(is);
        is.close();
        System.out.println("\nCreating a few non-project actions...");
        GettingThingsDoneDemo.createListItem(client, "finish filing taxes", "http://artificer.jboss.org/gettingthingsdone.owl#ComplexAction");
        GettingThingsDoneDemo.createListItem(client, "call insurance company", "http://artificer.jboss.org/gettingthingsdone.owl#SimpleAction");
        BaseArtifactType shoppingList = GettingThingsDoneDemo.createListItem(client, "write grocery shopping list", "http://artificer.jboss.org/gettingthingsdone.owl#ModerateAction");
        shoppingList.setDescription("item 1\nitem2\nitem3");
        client.updateArtifactMetaData(shoppingList);
        System.out.println("\nCreating project list...");
        BaseArtifactType demo = GettingThingsDoneDemo.createProject(client, "Artificer Demo");
        BaseArtifactType bathroom = GettingThingsDoneDemo.createProject(client, "Bathroom Remodel");
        BaseArtifactType bday = GettingThingsDoneDemo.createProject(client, "Plan Wife's Birthday Party");
        System.out.println("\nCreating project actions...");
        GettingThingsDoneDemo.createProjectListItem(client, "create slides", demo, "http://artificer.jboss.org/gettingthingsdone.owl#ModerateAction", "http://artificer.jboss.org/gettingthingsdone.owl#ComputerContext");
        GettingThingsDoneDemo.createProjectListItem(client, "create Java project", demo, "http://artificer.jboss.org/gettingthingsdone.owl#ModerateAction", "http://artificer.jboss.org/gettingthingsdone.owl#ComputerContext");
        GettingThingsDoneDemo.createProjectListItem(client, "buy paint", bathroom, "http://artificer.jboss.org/gettingthingsdone.owl#SimpleAction", "http://artificer.jboss.org/gettingthingsdone.owl#ErrandContext");
        BaseArtifactType shower = GettingThingsDoneDemo.createProjectListItem(client, "install new shower", bathroom, "http://artificer.jboss.org/gettingthingsdone.owl#ComplexAction");
        GettingThingsDoneDemo.createProjectListItem(client, "create invite list", bday, "http://artificer.jboss.org/gettingthingsdone.owl#ModerateAction");
        GettingThingsDoneDemo.createProjectListItem(client, "figure out a good gift", bday, "http://artificer.jboss.org/gettingthingsdone.owl#ComplexAction");
        System.out.println("\nCreating 'waiting' action ('book travel')...");
        BaseArtifactType travel = GettingThingsDoneDemo.createProjectListItem(client, "book travel", demo, "http://artificer.jboss.org/gettingthingsdone.owl#ModerateAction", "http://artificer.jboss.org/gettingthingsdone.owl#ComputerContext", "http://artificer.jboss.org/gettingthingsdone.owl#Waiting");
        travel.setDescription("Waiting for email confirming the demo location.");
        client.updateArtifactMetaData(travel);
        System.out.println("\nCreating 'someday' actions...");
        GettingThingsDoneDemo.createListItem(client, "complete RHCE certification", "http://artificer.jboss.org/gettingthingsdone.owl#Someday");
        GettingThingsDoneDemo.createListItem(client, "learn how to fly fish", "http://artificer.jboss.org/gettingthingsdone.owl#Someday");
        System.out.println("\nCheck out the web UI (http://localhost:8080/artificer-ui/index.html) to see how it all turned out.");
        System.out.println("\n*** Demo Completed ***\n\n");
    }

    private static BaseArtifactType createListItem(ArtificerAtomApiClient client, String name, String ... classifiers) throws Exception {
        BaseArtifactType action = GettingThingsDoneDemo.createListItem(name, classifiers);
        return client.createArtifact(action);
    }

    private static BaseArtifactType createProjectListItem(ArtificerAtomApiClient client, String name, BaseArtifactType project, String ... classifiers) throws Exception {
        BaseArtifactType action = GettingThingsDoneDemo.createListItem(name, classifiers);
        Target target = new Target();
        target.setValue(project.getUuid());
        Relationship relationship = new Relationship();
        relationship.setRelationshipType(GTD_PROJECT_RELATIONSHIP);
        relationship.getRelationshipTarget().add(target);
        action.getRelationship().add(relationship);
        return client.createArtifact(action);
    }

    private static BaseArtifactType createListItem(String name, String ... classifiers) {
        BaseArtifactType action = ArtifactType.ExtendedArtifactType((String)GTD_LIST_ITEM).newArtifactInstance();
        action.setName(name);
        for (String classifier : classifiers) {
            action.getClassifiedBy().add(classifier);
        }
        return action;
    }

    private static BaseArtifactType createProject(ArtificerAtomApiClient client, String name) throws Exception {
        BaseArtifactType action = ArtifactType.ExtendedArtifactType((String)GTD_PROJECT).newArtifactInstance();
        action.setName(name);
        return client.createArtifact(action);
    }
}

