/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.derived;

import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.query.QueryResultSet;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.query.ArtifactSummary;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;

public class DerivedArtifactsDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/artificer-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "artificer1!";

    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running Artificer Derived Artifacts Demo ***\n");
        String endpoint = System.getProperty("artificer.endpoint");
        String username = System.getProperty("artificer.auth.username");
        String password = System.getProperty("artificer.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("Artificer Endpoint: " + endpoint);
        System.out.println("Artificer User: " + username);
        ArtificerAtomApiClient client = new ArtificerAtomApiClient(endpoint, username, password, true);
        QueryResultSet rs = client.buildQuery("/s-ramp[@from-demo = ?]").parameter(DerivedArtifactsDemo.class.getSimpleName()).count(1).query();
        if (rs.size() > 0L) {
            System.out.println("It looks like you already ran this demo!");
            System.out.println("I'm going to quit, because I don't want to clutter up");
            System.out.println("your repository with duplicate stuff.");
            System.exit(1);
        }
        System.out.print("Uploading 'sample.wsdl' to the repo...");
        WsdlDocument wsdlArtifact = (WsdlDocument)client.uploadArtifact(ArtifactType.WsdlDocument(), DerivedArtifactsDemo.class.getResourceAsStream("sample.wsdl"), "sample.wsdl");
        System.out.println("uploaded.");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)wsdlArtifact, (String)"from-demo", (String)DerivedArtifactsDemo.class.getSimpleName());
        client.updateArtifactMetaData((BaseArtifactType)wsdlArtifact);
        System.out.println("-- It's query time. --");
        String q = String.format("/s-ramp/wsdl[relatedDocument[@uuid = '%1$s']]", wsdlArtifact.getUuid());
        QueryResultSet resultSet = client.query(q, 0, 100, "name", true);
        if (resultSet.size() != 30L) {
            System.out.println("Didn't find the right number of derived artifacts!  " + resultSet.size());
            for (ArtifactSummary as : resultSet) {
                System.out.println("  - " + as.getName() + " (" + as.getType() + ")");
            }
            System.exit(1);
        } else {
            System.out.println("Query #1 succeeded.");
        }
        q = String.format("/s-ramp/wsdl/Message[relatedDocument[@uuid = '%1$s']]", wsdlArtifact.getUuid());
        resultSet = client.query(q);
        if (resultSet.size() != 5L) {
            System.out.println("Didn't find the right number of WSDL message artifacts!");
            System.exit(1);
        } else {
            System.out.println("Query #2 succeeded.");
        }
        q = String.format("/s-ramp/wsdl/Part[relatedDocument[@uuid = '%1$s'] and element]", wsdlArtifact.getUuid());
        resultSet = client.query(q);
        if (resultSet.size() != 3L) {
            System.out.println("Didn't find the right number of element style parts!");
            System.exit(1);
        } else {
            System.out.println("Query #3 succeeded.");
        }
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }
}

