/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.query;

import java.io.Serializable;
import java.util.List;
import org.artificer.repository.query.ArtificerQueryArgs;

public class PagedResult<T>
implements Serializable {
    private final List<T> results;
    private final String query;
    private final long totalSize;
    private final ArtificerQueryArgs args;

    public PagedResult(List<T> results, String query, long totalSize, ArtificerQueryArgs args) {
        this.results = results;
        this.query = query;
        this.totalSize = totalSize;
        this.args = args;
    }

    public List<T> getResults() {
        return this.results;
    }

    public String getQuery() {
        return this.query;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getPageSize() {
        return this.args.getCount() == null ? this.totalSize : (long)this.args.getCount().intValue();
    }

    public int getStartIndex() {
        return this.args.getStartIndex() == null ? 0 : this.args.getStartIndex();
    }

    public String getOrderBy() {
        return this.args.getOrderBy();
    }

    public Boolean isAscending() {
        return this.args.getOrderAscending();
    }
}

