/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.query;

import java.io.Serializable;
import javax.persistence.Query;

public class ArtificerQueryArgs
implements Serializable {
    private String orderBy;
    private Boolean orderAscending;
    private Integer startIndex;
    private Integer count;

    public ArtificerQueryArgs() {
    }

    public ArtificerQueryArgs(String orderBy, Boolean orderAscending) {
        this.initOrdering(orderBy, orderAscending);
    }

    public ArtificerQueryArgs(Integer startPage, Integer startIndex, Integer count) {
        this.initPaging(startPage, startIndex, count);
    }

    public ArtificerQueryArgs(String orderBy, Boolean orderAscending, Integer startPage, Integer startIndex, Integer count) {
        this.initOrdering(orderBy, orderAscending);
        this.initPaging(startPage, startIndex, count);
    }

    private void initOrdering(String orderBy, Boolean orderAscending) {
        this.orderBy = orderBy == null ? "name" : orderBy;
        this.orderAscending = orderAscending == null ? true : orderAscending;
    }

    private void initPaging(Integer startPage, Integer startIndex, Integer count) {
        this.startIndex = this.startIndex(startPage, startIndex, count);
        this.count = count == null ? 100 : count;
    }

    private int startIndex(Integer startPage, Integer startIndex, Integer count) {
        if (startIndex == null && startPage != null) {
            int c = count != null ? count : 100;
            startIndex = (startPage - 1) * c;
        }
        if (startIndex == null) {
            startIndex = 0;
        }
        return startIndex;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Boolean getOrderAscending() {
        return this.orderAscending;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getCount() {
        return this.count;
    }

    public void applyPaging(Query query) {
        if (this.count != null) {
            query.setMaxResults(this.count.intValue());
        }
        if (this.startIndex != null) {
            query.setFirstResult(this.startIndex.intValue());
        }
    }
}

