/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.query;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.artificer.common.ArtificerException;
import org.artificer.common.query.xpath.ast.AbstractXPathNode;
import org.artificer.common.query.xpath.ast.Argument;
import org.artificer.common.query.xpath.ast.ArtifactSet;
import org.artificer.common.query.xpath.ast.EqualityExpr;
import org.artificer.common.query.xpath.ast.Expr;
import org.artificer.common.query.xpath.ast.ForwardPropertyStep;
import org.artificer.common.query.xpath.ast.OrExpr;
import org.artificer.common.query.xpath.ast.Predicate;
import org.artificer.common.query.xpath.ast.PrimaryExpr;
import org.artificer.common.query.xpath.visitors.XPathVisitor;
import org.artificer.repository.ClassificationHelper;
import org.artificer.repository.i18n.Messages;

public abstract class AbstractArtificerQueryVisitor
implements XPathVisitor {
    protected static final QName CLASSIFIED_BY_ANY_OF = new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "classifiedByAnyOf");
    protected static final QName CLASSIFIED_BY_ALL_OF = new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "classifiedByAllOf");
    protected static final QName EXACTLY_CLASSIFIED_BY_ANY_OF = new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "exactlyClassifiedByAnyOf");
    protected static final QName EXACTLY_CLASSIFIED_BY_ALL_OF = new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "exactlyClassifiedByAllOf");
    protected static final QName GET_RELATIONSHIP_ATTRIBUTE = new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "getRelationshipAttribute");
    protected static final QName GET_TARGET_ATTRIBUTE = new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "getTargetAttribute");
    protected static final QName MATCHES = new QName("http://www.w3.org/2005/xpath-functions", "matches");
    protected static final QName NOT = new QName("http://www.w3.org/2005/xpath-functions", "not");
    protected static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
    protected ClassificationHelper classificationHelper;
    protected ArtificerException error;
    private int uniqueArtifactCounter = 1;
    private int uniqueRelationshipCounter = 1;
    private int uniqueTargetCounter = 1;

    protected AbstractArtificerQueryVisitor(ClassificationHelper classificationHelper) {
        this.classificationHelper = classificationHelper;
    }

    public void visit(Argument node) {
        if (node.getPrimaryExpr() == null) {
            throw new RuntimeException(Messages.i18n.format("XP_ONLY_PRIMARY_FUNC_ARGS", new Object[0]));
        }
        node.getPrimaryExpr().accept((XPathVisitor)this);
    }

    public void visit(ArtifactSet node) {
        node.getLocationPath().accept((XPathVisitor)this);
    }

    public void visit(Expr node) {
        node.getAndExpr().accept((XPathVisitor)this);
    }

    public void visit(Predicate node) {
        node.getExpr().accept((XPathVisitor)this);
    }

    protected Collection<URI> resolveArgumentsToClassifications(List<Argument> arguments) {
        HashSet<String> classifiedBy = new HashSet<String>();
        for (int idx = 1; idx < arguments.size(); ++idx) {
            Argument arg = arguments.get(idx);
            if (arg.getPrimaryExpr() == null || arg.getPrimaryExpr().getLiteral() == null) {
                throw new RuntimeException(Messages.i18n.format("XP_INVALID_CLASSIFIER_FORMAT", new Object[0]));
            }
            classifiedBy.add(arg.getPrimaryExpr().getLiteral());
        }
        try {
            return this.classificationHelper.resolveAll(classifiedBy);
        }
        catch (ArtificerException e) {
            this.error = e;
            return Collections.emptySet();
        }
    }

    protected ForwardPropertyStep reducePropertyArgument(Argument argument) {
        try {
            ForwardPropertyStep fps = (ForwardPropertyStep)((EqualityExpr)((OrExpr)argument.getExpr().getAndExpr().getLeft()).getLeft()).getLeft();
            if (fps == null) {
                throw new NullPointerException();
            }
            return fps;
        }
        catch (Throwable t) {
            throw new RuntimeException(Messages.i18n.format("XP_EXPECTED_PROPERTY_ARG", new Object[0]));
        }
    }

    protected boolean isFullTextSearch(Argument argument) {
        AbstractXPathNode node = ((EqualityExpr)((OrExpr)argument.getExpr().getAndExpr().getLeft()).getLeft()).getLeft();
        if (node instanceof PrimaryExpr) {
            PrimaryExpr primaryExpr = (PrimaryExpr)node;
            return primaryExpr.getXpathValue().equals(".");
        }
        return false;
    }

    protected String reduceStringLiteralArgument(Argument argument) {
        try {
            String l = argument.getPrimaryExpr().getLiteral();
            if (l == null) {
                throw new NullPointerException();
            }
            return l;
        }
        catch (Throwable t) {
            throw new RuntimeException(Messages.i18n.format("XP_EXPECTED_STRING_LITERAL_ARG", new Object[0]));
        }
    }

    protected String escapeStringLiteral(String literal) {
        return literal.replace("'", "''");
    }

    protected String newArtifactAlias() {
        return "artifact" + this.uniqueArtifactCounter++;
    }

    protected String newRelationshipAlias() {
        return "relationship" + this.uniqueRelationshipCounter++;
    }

    protected String newTargetAlias() {
        return "target" + this.uniqueTargetCounter++;
    }
}

