/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository;

import java.util.Set;
import org.artificer.common.ArtificerConfig;
import org.artificer.repository.AuditManager;
import org.artificer.repository.PersistenceManager;
import org.artificer.repository.QueryManager;
import org.artificer.repository.RepositoryProvider;
import org.artificer.repository.i18n.Messages;
import org.overlord.commons.services.ServiceRegistryUtil;

public class RepositoryProviderFactory {
    private static RepositoryProvider provider = null;

    public static PersistenceManager persistenceManager() {
        return RepositoryProviderFactory.provider().persistenceManager();
    }

    public static QueryManager queryManager() {
        return RepositoryProviderFactory.provider().queryManager();
    }

    public static AuditManager auditManager() {
        return RepositoryProviderFactory.provider().auditManager();
    }

    private static RepositoryProvider provider() {
        if (provider == null) {
            String providerName = ArtificerConfig.getConfigProperty((String)"artificer.config.repository.provider", (String)"jpa");
            Set foundProviders = ServiceRegistryUtil.getServices(RepositoryProvider.class);
            for (RepositoryProvider foundProvider : foundProviders) {
                if (!foundProvider.name().equalsIgnoreCase(providerName)) continue;
                provider = foundProvider;
            }
            if (provider == null) {
                throw new RuntimeException(Messages.i18n.format("MISSING_REPO_PROVIDER", new Object[0]));
            }
        }
        return provider;
    }

    public static void overrideProvider(RepositoryProvider override) {
        provider = override;
    }
}

