/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration.switchyard.artifacttypedetector;

import java.io.File;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.integration.ArchiveContext;
import org.artificer.integration.artifacttypedetector.AbstractArtifactTypeDetector;
import org.artificer.integration.switchyard.artifacttypedetector.SwitchYardAppIndex;

public class SwitchYardArtifactTypeDetector
extends AbstractArtifactTypeDetector {
    public ArtifactType detect(ArtifactContent content) {
        if (content.getFilename().equals("switchyard.xml")) {
            return ArtifactType.valueOf((String)"SwitchYardXmlDocument", (boolean)true);
        }
        return null;
    }

    public ArtifactType detect(ArtifactContent content, ArchiveContext archiveContext) {
        if (archiveContext.isExpandedFromArchive()) {
            return this.detect(content);
        }
        File switchYardXml = this.getSwitchYardXml(archiveContext);
        if (switchYardXml != null) {
            SwitchYardAppIndex switchYardAppIndex = new SwitchYardAppIndex(switchYardXml);
            archiveContext.addCustomContext("switchyard.index", (Object)switchYardAppIndex);
            return ArtifactType.valueOf((String)"SwitchYardApplication", (boolean)true);
        }
        return null;
    }

    public boolean allowExpansionFromArchive(ArtifactContent content, ArchiveContext archiveContext) {
        if (content.getFilename().endsWith(".class")) {
            SwitchYardAppIndex switchYardAppIndex;
            String entryPath = content.getPath();
            String classname = entryPath.replace('/', '.').replace('\\', '.');
            classname = classname.substring(0, classname.length() - 6);
            if (archiveContext.hasCustomContext("switchyard.index") ? (switchYardAppIndex = (SwitchYardAppIndex)archiveContext.getCustomContext("switchyard.index")).contains(classname) : archiveContext.isExtendedTypeArchive("SwitchYardApplication")) {
                return true;
            }
        }
        return super.allowExpansionFromArchive(content, archiveContext);
    }

    private File getSwitchYardXml(ArchiveContext archiveContext) {
        if (archiveContext.hasArchiveEntry("WEB-INF/switchyard.xml")) {
            return archiveContext.getArchiveEntry("WEB-INF/switchyard.xml");
        }
        if (archiveContext.hasArchiveEntry("WEB-INF/classes/META-INF/switchyard.xml")) {
            return archiveContext.getArchiveEntry("WEB-INF/classes/META-INF/switchyard.xml");
        }
        if (archiveContext.hasArchiveEntry("META-INF/switchyard.xml")) {
            return archiveContext.getArchiveEntry("META-INF/switchyard.xml");
        }
        return null;
    }

    public int getPriority() {
        return 2;
    }
}

