/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.servlet.Filter;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.web.security.HttpHeadersRequestProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpRequestProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpWebRequestProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.support.RegisteredServiceCorsConfigurationSource;
import org.apereo.cas.services.web.support.RegisteredServiceResponseHeadersEnforcementFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.filters.AddResponseHeadersFilter;
import org.apereo.cas.web.support.filters.RequestParameterPolicyEnforcementFilter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.CorsFilter;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.WebApplication})
@AutoConfiguration
public class CasFiltersConfiguration {

    @Configuration(value="CasFiltersCorsConfiguration", proxyBeanMethods=false)
    public static class CasFiltersCorsConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.http-web-request.cors.enabled").isTrue();

        @Bean
        @ConditionalOnMissingBean(name={"corsHttpWebRequestConfigurationSource"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CorsConfigurationSource corsHttpWebRequestConfigurationSource(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (CorsConfigurationSource)BeanSupplier.of(CorsConfigurationSource.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new RegisteredServiceCorsConfigurationSource(casProperties, servicesManager, argumentExtractor)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"casCorsFilter"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FilterRegistrationBean<CorsFilter> casCorsFilter(CasConfigurationProperties casProperties, @Qualifier(value="corsHttpWebRequestConfigurationSource") CorsConfigurationSource corsHttpWebRequestConfigurationSource) {
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter(corsHttpWebRequestConfigurationSource), new ServletRegistrationBean[0]);
            bean.setName("casCorsFilter");
            bean.setAsyncSupported(true);
            bean.setOrder(0);
            bean.setEnabled(casProperties.getHttpWebRequest().getCors().isEnabled());
            return bean;
        }
    }

    @Configuration(value="CasFiltersResponseHeadersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureAfter(value={CasCoreServicesConfiguration.class})
    public static class CasFiltersResponseHeadersConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FilterRegistrationBean<AddResponseHeadersFilter> responseHeadersFilter(CasConfigurationProperties casProperties) {
            FilterRegistrationBean bean = new FilterRegistrationBean();
            AddResponseHeadersFilter filter = new AddResponseHeadersFilter();
            filter.setHeadersMap(casProperties.getHttpWebRequest().getCustomHeaders());
            bean.setFilter((Filter)filter);
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("responseHeadersFilter");
            bean.setAsyncSupported(true);
            return bean;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FilterRegistrationBean<RegisteredServiceResponseHeadersEnforcementFilter> responseHeadersSecurityFilter(CasConfigurationProperties casProperties, @Qualifier(value="argumentExtractor") ObjectProvider<ArgumentExtractor> argumentExtractor, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, @Qualifier(value="registeredServiceAccessStrategyEnforcer") ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, @Qualifier(value="authenticationServiceSelectionPlan") ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies) {
            HttpHeadersRequestProperties header = casProperties.getHttpWebRequest().getHeader();
            HashMap<String, String> initParams = new HashMap<String, String>();
            initParams.put("enableCacheControl", BooleanUtils.toStringTrueFalse((boolean)header.isCache()));
            initParams.put("enableXContentTypeOptions", BooleanUtils.toStringTrueFalse((boolean)header.isXcontent()));
            initParams.put("enableStrictTransportSecurity", BooleanUtils.toStringTrueFalse((boolean)header.isHsts()));
            initParams.put("enableStrictTransportSecurityOptions", header.getHstsOptions());
            initParams.put("enableXFrameOptions", BooleanUtils.toStringTrueFalse((boolean)header.isXframe()));
            initParams.put("XFrameOptions", header.getXframeOptions());
            initParams.put("enableXSSProtection", BooleanUtils.toStringTrueFalse((boolean)header.isXss()));
            initParams.put("XSSProtection", header.getXssOptions());
            initParams.put("cacheControlStaticResources", header.getCacheControlStaticResources());
            if (StringUtils.isNotBlank((CharSequence)header.getContentSecurityPolicy())) {
                initParams.put("contentSecurityPolicy", header.getContentSecurityPolicy());
            }
            FilterRegistrationBean bean = new FilterRegistrationBean();
            RegisteredServiceResponseHeadersEnforcementFilter filter = new RegisteredServiceResponseHeadersEnforcementFilter(servicesManager, argumentExtractor, authenticationRequestServiceSelectionStrategies, registeredServiceAccessStrategyEnforcer);
            bean.setFilter((Filter)filter);
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setInitParameters(initParams);
            bean.setName("responseHeadersSecurityFilter");
            bean.setAsyncSupported(true);
            bean.setEnabled(casProperties.getHttpWebRequest().getHeader().isEnabled());
            return bean;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FilterRegistrationBean<RequestParameterPolicyEnforcementFilter> requestParameterSecurityFilter(CasConfigurationProperties casProperties) {
            HttpRequestProperties httpWebRequest = casProperties.getHttpWebRequest();
            HashMap<String, String> initParams = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)httpWebRequest.getParamsToCheck())) {
                initParams.put("parametersToCheck", httpWebRequest.getParamsToCheck());
            }
            initParams.put("charactersToForbid", httpWebRequest.getCharactersToForbid());
            initParams.put("allowMultiValuedParameters", BooleanUtils.toStringTrueFalse((boolean)httpWebRequest.isAllowMultiValueParameters()));
            initParams.put("onlyPostParameters", httpWebRequest.getOnlyPostParams());
            if (StringUtils.isNotBlank((CharSequence)httpWebRequest.getPatternToBlock())) {
                initParams.put("patternToBlock", httpWebRequest.getPatternToBlock());
            }
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)new RequestParameterPolicyEnforcementFilter());
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("requestParameterSecurityFilter");
            bean.setInitParameters(initParams);
            bean.setAsyncSupported(true);
            return bean;
        }
    }

    @Configuration(value="CasFiltersEncodingConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasFiltersBaseConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public FilterRegistrationBean<CharacterEncodingFilter> characterEncodingFilter(CasConfigurationProperties casProperties) {
            FilterRegistrationBean bean = new FilterRegistrationBean();
            HttpWebRequestProperties web = casProperties.getHttpWebRequest().getWeb();
            bean.setFilter((Filter)new CharacterEncodingFilter(web.getEncoding(), web.isForceEncoding()));
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("characterEncodingFilter");
            bean.setAsyncSupported(true);
            return bean;
        }
    }
}

