/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.acct.provision.AccountRegistrationProvisionerConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAccountManagementRegistrationProvisioningProperties;
import org.apereo.cas.syncope.SyncopeAccountRegistrationProvisioner;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnClass(value={AccountRegistrationProvisionerConfigurer.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountRegistration}, module="syncope")
@AutoConfiguration
public class SyncopeAccountManagementConfiguration {
    @ConditionalOnMissingBean(name={"syncopeAccountRegistrationProvisionerConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AccountRegistrationProvisionerConfigurer syncopeAccountRegistrationProvisionerConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
        return (AccountRegistrationProvisionerConfigurer)BeanSupplier.of(AccountRegistrationProvisionerConfigurer.class).when(BeanCondition.on((String)"cas.account-registration.provisioning.syncope.url").isUrl().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> {
            SyncopeAccountManagementRegistrationProvisioningProperties syncope = casProperties.getAccountRegistration().getProvisioning().getSyncope();
            return new SyncopeAccountRegistrationProvisioner(syncope);
        }).otherwiseProxy().get();
    }
}

