/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.bucket4j.consumer.BucketConsumer;
import org.apereo.cas.bucket4j.consumer.DefaultBucketConsumer;
import org.apereo.cas.bucket4j.producer.BucketStore;
import org.apereo.cas.bucket4j.producer.InMemoryBucketStore;
import org.apereo.cas.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.bucket4j.BaseBucket4jProperties;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.simple.CoreCasSimpleMultifactorAuthenticationTokenProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCommunicationStrategy;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketImpl;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationUniqueTicketIdGenerator;
import org.apereo.cas.mfa.simple.ticket.DefaultCasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.mfa.simple.web.CasSimpleMultifactorAuthenticationEndpoint;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorSendTokenAction;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorWebflowConfigurer;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.serialization.TicketSerializationExecutionPlanConfigurer;
import org.apereo.cas.util.serialization.AbstractJacksonBackedStringSerializer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SimpleMFA})
@AutoConfiguration
public class CasSimpleMultifactorAuthenticationConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;
    private static final BeanCondition CONDITION_BUCKET4J_ENABLED = BeanCondition.on((String)"cas.authn.mfa.simple.bucket4j.enabled").isTrue();

    @Configuration(value="CasSimpleMultifactorSurrogateAuthenticationWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnClass(value={SurrogateAuthenticationService.class})
    public static class CasSimpleMultifactorSurrogateAuthenticationWebflowPlanConfiguration {
        @Bean
        @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SurrogateAuthentication})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateCasSimpleMultifactorAuthenticationWebflowConfigurer"})
        public CasWebflowConfigurer surrogateCasSimpleMultifactorAuthenticationWebflowConfigurer(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new SurrogateWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"surrogateCasSimpleMultifactorAuthenticationWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer surrogateCasSimpleMultifactorAuthenticationWebflowExecutionPlanConfigurer(@Qualifier(value="surrogateCasSimpleMultifactorAuthenticationWebflowConfigurer") CasWebflowConfigurer surrogateWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(surrogateWebflowConfigurer);
        }

        private static final class SurrogateWebflowConfigurer
        extends AbstractCasWebflowConfigurer {
            SurrogateWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry mainFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
                super(flowBuilderServices, mainFlowDefinitionRegistry, applicationContext, casProperties);
                this.setOrder(Integer.MAX_VALUE);
            }

            protected void doInitialize() {
                TransitionableState mfaState = this.getState(this.getLoginFlow(), this.casProperties.getAuthn().getMfa().getSimple().getId());
                this.createTransitionForState(mfaState, "success", "loadSurrogatesAction", true);
            }
        }
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @Configuration(value="CasSimpleMultifactorTrustConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"casSimpleMultifactorAuthenticationTicketFactoryConfigurer"})
    public static class CasSimpleMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorTrustWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer mfaSimpleMultifactorTrustWebflowConfigurer(@Qualifier(value="mfaSimpleAuthenticatorFlowRegistry") FlowDefinitionRegistry mfaSimpleAuthenticatorFlowRegistry, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            CasSimpleMultifactorTrustedDeviceWebflowConfigurer cfg = new CasSimpleMultifactorTrustedDeviceWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, mfaSimpleAuthenticatorFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @ConditionalOnMissingBean(name={"casSimpleMultifactorTrustWebflowExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer casSimpleMultifactorTrustWebflowExecutionPlanConfigurer(@Qualifier(value="mfaSimpleMultifactorTrustWebflowConfigurer") CasWebflowConfigurer mfaSimpleMultifactorTrustWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(mfaSimpleMultifactorTrustWebflowConfigurer);
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationTicketFactoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSimpleMultifactorAuthenticationTicketFactoryPlanConfiguration {
        @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer casSimpleMultifactorAuthenticationTicketFactoryConfigurer(@Qualifier(value="casSimpleMultifactorAuthenticationTicketFactory") CasSimpleMultifactorAuthenticationTicketFactory casSimpleMultifactorAuthenticationTicketFactory) {
            return () -> casSimpleMultifactorAuthenticationTicketFactory;
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationTicketSerializationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSimpleMultifactorAuthenticationTicketSerializationConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketSerializationExecutionPlanConfigurer casSimpleMultifactorAuthenticationTicketSerializationExecutionPlanConfigurer() {
            return plan -> {
                plan.registerTicketSerializer((StringSerializer)new CasSimpleMultifactorAuthenticationTicketStringSerializer());
                plan.registerTicketSerializer(CasSimpleMultifactorAuthenticationTicket.class.getName(), (StringSerializer)new CasSimpleMultifactorAuthenticationTicketStringSerializer());
            };
        }

        private static final class CasSimpleMultifactorAuthenticationTicketStringSerializer
        extends AbstractJacksonBackedStringSerializer<CasSimpleMultifactorAuthenticationTicketImpl> {
            private static final long serialVersionUID = -2198623586274810263L;

            private CasSimpleMultifactorAuthenticationTicketStringSerializer() {
            }

            public Class<CasSimpleMultifactorAuthenticationTicketImpl> getTypeToSerialize() {
                return CasSimpleMultifactorAuthenticationTicketImpl.class;
            }
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationTicketFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSimpleMultifactorAuthenticationTicketFactoryConfiguration {
        @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasSimpleMultifactorAuthenticationTicketFactory casSimpleMultifactorAuthenticationTicketFactory(@Qualifier(value="casSimpleMultifactorAuthenticationUniqueTicketIdGenerator") UniqueTicketIdGenerator casSimpleMultifactorAuthenticationUniqueTicketIdGenerator, @Qualifier(value="casSimpleMultifactorAuthenticationTicketExpirationPolicy") ExpirationPolicyBuilder casSimpleMultifactorAuthenticationTicketExpirationPolicy) {
            return new DefaultCasSimpleMultifactorAuthenticationTicketFactory(casSimpleMultifactorAuthenticationTicketExpirationPolicy, casSimpleMultifactorAuthenticationUniqueTicketIdGenerator);
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationTicketConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSimpleMultifactorAuthenticationTicketConfiguration {
        @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder casSimpleMultifactorAuthenticationTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationUniqueTicketIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator casSimpleMultifactorAuthenticationUniqueTicketIdGenerator(CasConfigurationProperties casProperties) {
            CoreCasSimpleMultifactorAuthenticationTokenProperties simple = casProperties.getAuthn().getMfa().getSimple().getToken().getCore();
            return new CasSimpleMultifactorAuthenticationUniqueTicketIdGenerator(simple.getTokenLength());
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSimpleMultifactorAuthenticationWebflowConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaSimpleAuthenticatorFlowRegistry"})
        public FlowDefinitionRegistry mfaSimpleAuthenticatorFlowRegistry(CasConfigurationProperties casProperties, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, ConfigurableApplicationContext applicationContext) {
            FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
            builder.addFlowBuilder(flowBuilder, casProperties.getAuthn().getMfa().getSimple().getId());
            return builder.build();
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorTokenCommunicationStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasSimpleMultifactorTokenCommunicationStrategy mfaSimpleMultifactorTokenCommunicationStrategy() {
            return CasSimpleMultifactorTokenCommunicationStrategy.all();
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSimpleMultifactorAuthenticationBaseConfiguration {
        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer mfaSimpleMultifactorWebflowConfigurer(@Qualifier(value="mfaSimpleAuthenticatorFlowRegistry") FlowDefinitionRegistry mfaSimpleAuthenticatorFlowRegistry, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            CasSimpleMultifactorWebflowConfigurer cfg = new CasSimpleMultifactorWebflowConfigurer(flowBuilderServices, loginFlowRegistry, mfaSimpleAuthenticatorFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
            cfg.setOrder(100);
            return cfg;
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSimpleMultifactorAuthenticationPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaSimpleCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer mfaSimpleCasWebflowExecutionPlanConfigurer(@Qualifier(value="mfaSimpleMultifactorWebflowConfigurer") CasWebflowConfigurer mfaSimpleMultifactorWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(mfaSimpleMultifactorWebflowConfigurer);
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasSimpleMultifactorAuthenticationActionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public CasSimpleMultifactorAuthenticationEndpoint mfaSimpleMultifactorEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new CasSimpleMultifactorAuthenticationEndpoint(casProperties, applicationContext);
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorSendTokenAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action mfaSimpleMultifactorSendTokenAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSimpleMultifactorAuthenticationService") CasSimpleMultifactorAuthenticationService casSimpleMultifactorAuthenticationService, @Qualifier(value="mfaSimpleMultifactorTokenCommunicationStrategy") CasSimpleMultifactorTokenCommunicationStrategy mfaSimpleMultifactorTokenCommunicationStrategy, CasConfigurationProperties casProperties, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="mfaSimpleMultifactorBucketConsumer") BucketConsumer mfaSimpleMultifactorBucketConsumer) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> {
                CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
                return new CasSimpleMultifactorSendTokenAction(communicationsManager, casSimpleMultifactorAuthenticationService, simple, mfaSimpleMultifactorTokenCommunicationStrategy, mfaSimpleMultifactorBucketConsumer);
            }).withId("mfaSimpleMultifactorSendTokenAction").build().get();
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorBucketConsumer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BucketConsumer mfaSimpleMultifactorBucketConsumer(ConfigurableApplicationContext applicationContext, @Qualifier(value="mfaSimpleMultifactorBucketStore") BucketStore mfaSimpleMultifactorBucketStore, CasConfigurationProperties casProperties) {
            return (BucketConsumer)BeanSupplier.of(BucketConsumer.class).when(CONDITION_BUCKET4J_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
                return new DefaultBucketConsumer(mfaSimpleMultifactorBucketStore, (BaseBucket4jProperties)simple.getBucket4j());
            }).otherwise(BucketConsumer::permitAll).get();
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorBucketStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BucketStore mfaSimpleMultifactorBucketStore(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BucketStore)BeanSupplier.of(BucketStore.class).when(CONDITION_BUCKET4J_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
                return new InMemoryBucketStore((BaseBucket4jProperties)simple.getBucket4j());
            }).otherwiseProxy().get();
        }
    }
}

